/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.item.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.validator.BatchFastValidator;

public class ItemValidator
extends BatchFastValidator {
    private Map<Object, List<Long>> materialUnits = new HashMap<Object, List<Long>>();

    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        this.preLoadMaterialUnits(datas);
        for (ExtendedDataEntity data : datas) {
            Object assistUnitId;
            DynamicObject item = data.getDataEntity();
            DynamicObject material = item.getDynamicObject("material");
            if (material == null) {
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u672a\u586b\u5199\u7269\u6599", (String)"ItemValidator_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]), item.get("number")));
                continue;
            }
            DynamicObject saleUnit = item.getDynamicObject("saleunit");
            if (saleUnit == null) {
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u672a\u586b\u5199\u9500\u552e\u5355\u4f4d", (String)"ItemValidator_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]), item.get("number")));
                continue;
            }
            Object saleUnitId = saleUnit.get("id");
            CheckResult resut = this.checkUnitInMaterialUnits(saleUnitId, material.get("id"));
            if (!resut.isSuccess()) {
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u9500\u552e\u5355\u4f4d\u3010%s\u3011\u4e0d\u5728\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u4e2d", (String)"ItemValidator_2", (String)"drp-dbd-opplugin", (Object[])new Object[0]), item.get("number"), saleUnit.get("number")));
                continue;
            }
            DynamicObject assistUnit = item.getDynamicObject("assistunit");
            if (assistUnit == null || (resut = this.checkUnitInMaterialUnits(assistUnitId = assistUnit.get("id"), material.get("id"))).isSuccess()) continue;
            this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u8f85\u52a9\u5355\u4f4d\u3010%s\u3011\u4e0d\u5728\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u4e2d", (String)"ItemValidator_3", (String)"drp-dbd-opplugin", (Object[])new Object[0]), item.get("number"), assistUnit.get("number")));
        }
    }

    private void preLoadMaterialUnits(ExtendedDataEntity[] datas) {
        HashSet<Object> materialIds = new HashSet<Object>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject item = data.getDataEntity();
            DynamicObject material = item.getDynamicObject("material");
            if (material == null) continue;
            materialIds.add(material.get("id"));
        }
        this.materialUnits = ItemUtil.loadMaterialUnitsFromService(materialIds);
    }

    private CheckResult checkUnitInMaterialUnits(Object unitId, Object materialId) {
        List<Long> unitList = this.materialUnits.get(materialId);
        if (unitList != null && unitList.contains(unitId)) {
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)"");
    }
}

