/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.itembarcode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.itembarcode.ItemBarcodeValidator;

public class ItemBarcodeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("materiel");
        e.getFieldKeys().add("auxpty");
        e.getFieldKeys().add("barcode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ItemBarcodeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        this.syncItem2Barcode(key, e.getDataEntities());
    }

    private void syncItem2Barcode(String key, DynamicObject[] datas) {
        List itembracodes = Arrays.asList(datas).stream().filter(m -> m.getPkValue() != null && m.getPkValue().equals(m.getDynamicObject("item").getLong("barcode"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itembracodes)) {
            ArrayList<DynamicObject> items = new ArrayList<DynamicObject>(itembracodes.size());
            for (DynamicObject data : itembracodes) {
                Object itemId = data.getDynamicObject("item").getPkValue();
                Object barcodeId = data.getPkValue();
                Object barcodenumber = data.get("barcode");
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info");
                object.set("barcode", barcodeId);
                object.set("barcodenumber", barcodenumber);
                items.add(object);
            }
            if (key.equals("save")) {
                SaveServiceHelper.update((DynamicObject[])items.toArray(new DynamicObject[items.size()]));
            }
        }
    }
}

