/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.itemsalecontent;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.ItemSaleContentUtils;
import kd.drp.dbd.opplugin.itemsalecontent.validator.ItemPriceChangeTplValidator;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import org.apache.log4j.Logger;

public class ItemPriceChangeTplOp
extends MdrBaseOperationServicePlugIn {
    private Logger logger = Logger.getLogger(ItemPriceChangeTplOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("createorg");
        fieldKeys.add("currency");
        fieldKeys.add("billstatus");
        fieldKeys.add("customer_entry");
        fieldKeys.add("customergroupid");
        fieldKeys.add("customerid");
        fieldKeys.add("item_entry");
        fieldKeys.add("barcode");
        fieldKeys.add("spuid");
        fieldKeys.add("item");
        fieldKeys.add("materiel");
        fieldKeys.add("auxpty");
        fieldKeys.add("memberprice");
        fieldKeys.add("retailprice");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ItemPriceChangeTplValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opString = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (opString) {
            case "audit": {
                if (this.operationResult.isSuccess() && objs.length > 0) {
                    this.saveItemsaleContentChange(objs);
                    break;
                }
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage("\u5339\u914d\u7684\u7ecf\u8425\u76ee\u5f55\u4e3a\u7a7a");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveItemsaleContentChange(DynamicObject[] objs) {
        String entityNum = ItemSaleContentUtils.getEntityNum((String)objs[0].getDynamicObjectType().getName());
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        for (int i = 0; i < objs.length; ++i) {
            Object createOrgId = objs[i].getDynamicObject("createorg").getPkValue();
            Object currencyId = objs[i].getDynamicObject("currency").getPkValue();
            DynamicObjectCollection customer_entrys = (DynamicObjectCollection)objs[i].get("customer_entry");
            DynamicObjectCollection barcode_entrys = (DynamicObjectCollection)objs[i].get("item_entry");
            Set customerIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customerid") != null).map(m -> m.getDynamicObject("customerid").getPkValue()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(customerIds) || customerIds.size() != customer_entrys.size()) {
                List customergroupIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customergroupid") != null).map(m -> m.getDynamicObject("customergroupid").getPkValue()).collect(Collectors.toList());
                QFilter filter = new QFilter("custclassentity.customergroupid", "in", (Object)customergroupIds.toArray());
                filter.and(ItemSaleContentUtils.getCustomerTypeQfiter((String)entityNum));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{filter});
                Set group2customerIds = collection.stream().map(m -> m.getString("id")).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(customerIds)) {
                    customerIds = group2customerIds;
                } else {
                    customerIds.addAll(group2customerIds);
                }
            }
            for (Object customerid : customerIds) {
                for (DynamicObject entry : barcode_entrys) {
                    DynamicObject object = null;
                    object = BusinessDataServiceHelper.newDynamicObject((String)entityNum);
                    object.set(DynamicObjectUtils.append_Id((String)"createorg"), createOrgId);
                    object.set(DynamicObjectUtils.append_Id((String)"currency"), currencyId);
                    object.set(DynamicObjectUtils.append_Id((String)"customer"), customerid);
                    object.set(DynamicObjectUtils.append_Id((String)"item"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("item")));
                    object.set(DynamicObjectUtils.append_Id((String)"spuid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("spuid")));
                    object.set("memberprice", entry.get("memberprice"));
                    object.set("retailprice", entry.get("retailprice"));
                    if ("dbd_itemsale_content".equals(entityNum)) {
                        object.set(DynamicObjectUtils.append_Id((String)"barcode"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("barcode")));
                    } else if ("olmm_itemsale_content".equals(entityNum)) {
                        object.set(DynamicObjectUtils.append_Id((String)"materielid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("materiel")));
                        object.set(DynamicObjectUtils.append_Id((String)"auxptyid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("auxpty")));
                    }
                    datas.add(object);
                }
            }
        }
        OperationResult result = ItemSaleContentUtils.createOperationResult((int)0, new ArrayList(), new ArrayList(), (boolean)true, (String)"\u65e0\u5339\u914d\u5546\u54c1\u7ecf\u8425\u76ee\u5f55");
        try {
            if (!CollectionUtils.isEmpty(datas)) {
                BusinessDataServiceHelper.loadRefence((Object[])datas.toArray(), (IDataEntityType)((DynamicObject)datas.get(0)).getDataEntityType());
                result = OperationServiceHelper.executeOperate((String)"change", (String)entityNum, (DynamicObject[])datas.toArray(new DynamicObject[0]));
                if (!result.isSuccess()) {
                    this.logger.error((Object)String.format("\u8c03\u6574\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c%s", result.getMessage()));
                    result.setMessage(String.format("\u8c03\u6574\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c%s", result.getMessage()));
                } else {
                    result.setMessage("\u8c03\u6574\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c\u6210\u529f");
                }
            } else {
                result.setMessage("\u6ca1\u6709\u5230\u5339\u914d\u5546\u54c1\u7ecf\u8425\u76ee\u5f55");
                result.setSuccess(false);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8c03\u6574\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c\u5931\u8d25", (Throwable)e);
            result.setSuccess(false);
            result.setMessage(String.format("\u8c03\u6574\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c\u5931\u8d25%s", e.getMessage()));
        }
        finally {
            String resultStr = ItemSaleContentUtils.operationResult2JsonStr((OperationResult)result);
            this.operateOption.setVariableValue("itemsale_content_result", resultStr);
            datas.clear();
        }
    }
}

