/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.itemsalecontent;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.ItemSaleContentUtils;
import kd.drp.dbd.opplugin.itemsalecontent.validator.ItemSaleContentPulishTplValidator;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemSaleContentPublishTplOp
extends MdrBaseOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ItemSaleContentPublishTplOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entryentity_customer");
        e.getFieldKeys().add("customergroupid");
        e.getFieldKeys().add("customerid");
        e.getFieldKeys().add("entryentity_item");
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("spuid");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("auxpty");
        e.getFieldKeys().add("materiel");
        e.getFieldKeys().add("memberprice");
        e.getFieldKeys().add("retailprice");
        e.getFieldKeys().add("retailstate");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ItemSaleContentPulishTplValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String opString = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (opString) {
            case "audit": {
                this.savePublish(objs);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePublish(DynamicObject[] objs) {
        OperationResult result = ItemSaleContentUtils.createOperationResult((int)0, new ArrayList(), new ArrayList(), (boolean)true, (String)"\u65e0\u5339\u914d\u7ecf\u8425\u76ee\u5f55");
        if (this.operationResult.isSuccess() && objs.length > 0) {
            String entityNum = ItemSaleContentUtils.getEntityNum((String)objs[0].getDynamicObjectType().getName());
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            for (int i = 0; i < objs.length; ++i) {
                Object createOrgId = objs[i].getDynamicObject("createorg").getPkValue();
                Object currencyId = objs[i].getDynamicObject("currency").getPkValue();
                DynamicObjectCollection customer_entrys = (DynamicObjectCollection)objs[i].get("entryentity_customer");
                DynamicObjectCollection barcode_entrys = (DynamicObjectCollection)objs[i].get("entryentity_item");
                Set customerIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customerid") != null).map(m -> m.getDynamicObject("customerid").getPkValue()).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(customerIds) || customerIds.size() != customer_entrys.size()) {
                    List customergroupIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customergroupid") != null).map(m -> m.getDynamicObject("customergroupid").getPkValue()).collect(Collectors.toList());
                    QFilter filter = new QFilter("custclassentity.customergroupid", "in", (Object)customergroupIds.toArray());
                    filter.and(ItemSaleContentUtils.getCustomerTypeQfiter((String)entityNum));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{filter});
                    Set group2customerIds = collection.stream().map(m -> m.getString("id")).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(customerIds)) {
                        customerIds = group2customerIds;
                    } else {
                        customerIds.addAll(group2customerIds);
                    }
                }
                for (Object customerid : customerIds) {
                    for (DynamicObject entry : barcode_entrys) {
                        DynamicObject object = null;
                        object = BusinessDataServiceHelper.newDynamicObject((String)entityNum);
                        object.set(DynamicObjectUtils.append_Id((String)"createorg"), createOrgId);
                        object.set(DynamicObjectUtils.append_Id((String)"currency"), currencyId);
                        object.set(DynamicObjectUtils.append_Id((String)"customer"), customerid);
                        object.set(DynamicObjectUtils.append_Id((String)"item"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("item")));
                        object.set(DynamicObjectUtils.append_Id((String)"spuid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("spuid")));
                        object.set("memberprice", entry.get("memberprice"));
                        object.set("retailprice", entry.get("retailprice"));
                        object.set("enable", (Object)Enable.ENABLE);
                        object.set("retailstate", entry.get("retailstate"));
                        if ("dbd_itemsale_content".equals(entityNum)) {
                            object.set(DynamicObjectUtils.append_Id((String)"barcode"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("barcode")));
                        } else if ("olmm_itemsale_content".equals(entityNum)) {
                            object.set(DynamicObjectUtils.append_Id((String)"materielid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("materiel")));
                            object.set(DynamicObjectUtils.append_Id((String)"auxptyid"), (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("auxpty")));
                        }
                        datas.add(object);
                    }
                }
            }
            try {
                if (!CollectionUtils.isEmpty(datas)) {
                    BusinessDataServiceHelper.loadRefence((Object[])datas.toArray(), (IDataEntityType)((DynamicObject)datas.get(0)).getDataEntityType());
                    result = OperationServiceHelper.executeOperate((String)"save", (String)entityNum, (DynamicObject[])datas.toArray(new DynamicObject[datas.size()]));
                    if (!result.isSuccess()) {
                        logger.error(String.format("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u5931\u8d25%s", result.getMessage()));
                        result.setSuccess(false);
                        result.setMessage(String.format("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u5931\u8d25%s", result.getMessage()));
                    }
                    result.setMessage("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6210\u529f");
                }
                result.setMessage(String.format("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55%s\u6210\u529f", 0));
            }
            catch (Exception e) {
                logger.error("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u5931\u8d25", (Throwable)e);
                result.setSuccess(false);
                result.setMessage(String.format("\u53d1\u5e03\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u5931\u8d25%s", e.getMessage()));
            }
            finally {
                datas.clear();
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u53d1\u5e03\u7ecf\u8425\u76ee\u5f55\u4e3a\u7a7a");
        }
        String resultStr = ItemSaleContentUtils.operationResult2JsonStr((OperationResult)result);
        this.operateOption.setVariableValue("itemsale_content_result", resultStr);
    }
}

