/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.itemsalecontent;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.ItemSaleContentUtils;
import kd.drp.dbd.opplugin.itemsalecontent.validator.ItemSaleContentTplValidator;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemSaleContentTplOp
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("headid");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("spuid");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("memberprice");
        e.getFieldKeys().add("retailprice");
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("materielid");
        e.getFieldKeys().add("auxptyid");
        e.getFieldKeys().add("unitid");
        e.getFieldKeys().add("retailstate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ItemSaleContentTplValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opkey = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (opkey) {
            case "save": 
            case "delete": {
                ItemSaleContentUtils.updateItemContentHead((String)opkey, (DynamicObject[])datas);
                break;
            }
            case "change": {
                this.changePrice(datas);
            }
        }
    }

    private void changePrice(DynamicObject[] datas) {
        ArrayList<void> saveData = new ArrayList<void>(datas.length);
        for (DynamicObject data : datas) {
            Long createorgid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"createorg");
            Long currencyid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"currency");
            Long customerid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"customer");
            Long itemid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"item");
            Long spuid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"spuid");
            QFilter createOrgIdFilter = new QFilter("createorg", "=", (Object)createorgid);
            QFilter currencyIdFilter = new QFilter("currency", "=", (Object)currencyid);
            QFilter customerIdFilter = new QFilter("customer", "=", (Object)customerid);
            QFilter itemidFilter = new QFilter("item", "=", (Object)itemid);
            QFilter spuidFilter = new QFilter("spuid", "=", (Object)spuid);
            String entityNum = data.getDataEntityType().getName();
            DynamicObject[] dbDy = null;
            if ("dbd_itemsale_content".equalsIgnoreCase(entityNum)) {
                Long barcodeid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"barcode");
                QFilter barcodeidFilter = new QFilter("barcode", "=", (Object)barcodeid);
                createOrgIdFilter.and(currencyIdFilter).and(customerIdFilter).and(itemidFilter).and(spuidFilter).and(barcodeidFilter);
                dbDy = BusinessDataServiceHelper.load((String)entityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"createorg", "currency", "customer", "item", "barcode", "spuid", "headid", "memberprice", "retailprice"}), (QFilter[])createOrgIdFilter.toArray());
            } else if ("olmm_itemsale_content".equalsIgnoreCase(entityNum)) {
                Long auxptyid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"auxptyid");
                Long unitid = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"unitid");
                QFilter auxptyidFilter = new QFilter("auxptyid", "=", (Object)auxptyid);
                QFilter unitidFilter = new QFilter("unitid", "=", (Object)unitid);
                createOrgIdFilter.and(currencyIdFilter).and(customerIdFilter).and(itemidFilter).and(spuidFilter).and(auxptyidFilter).and(unitidFilter);
                dbDy = BusinessDataServiceHelper.load((String)entityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"createorg", "currency", "customer", "item", "auxptyid", "unitid", "spuid", "headid", "memberprice", "retailprice"}), (QFilter[])createOrgIdFilter.toArray());
            }
            if (dbDy == null || dbDy.length != 1) {
                OperateErrorInfo ErrorInfo = new OperateErrorInfo("drp.dbd", ErrorLevel.FatalError, data.getPkValue());
                ErrorInfo.setTitle("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u9519\u8bef");
                if ("dbd_itemsale_content".equalsIgnoreCase(entityNum)) {
                    ErrorInfo.setMessage(String.format("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u9519\u8bef,\u95e8\u5e97%s+\u6761\u5f62\u7801%s+spu%s\u5339\u914d\u6570\u76ee\u4e0d\u5bf9", data.getDynamicObject("customer").get("number"), data.getDynamicObject("barcode").get("barcode"), data.getDynamicObject("spuid").get("number")));
                } else {
                    ErrorInfo.setMessage(String.format("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u9519\u8bef,\u95e8\u5e97%s+\u5546\u54c1%s+\u5355\u4f4d%s+spu%s\u5339\u914d\u6570\u76ee\u4e0d\u5bf9", data.getDynamicObject("customer").get("number"), data.getDynamicObject("item").get("number"), data.getDynamicObject("unitid").get("number"), data.getDynamicObject("spuid").get("number")));
                }
                this.operationResult.addErrorInfo(ErrorInfo);
                continue;
            }
            dbDy[0].set("memberprice", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"memberprice"));
            dbDy[0].set("retailprice", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"retailprice"));
            saveData.add(dbDy[0]);
        }
        if (!CollectionUtils.isEmpty(saveData)) {
            SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[saveData.size()]));
            ItemSaleContentUtils.updateItemContentHead((String)"change", (DynamicObject[])saveData.toArray(new DynamicObject[saveData.size()]));
        } else {
            OperateErrorInfo ErrorInfo = new OperateErrorInfo("drp.dbd", ErrorLevel.FatalError, (Object)0L);
            ErrorInfo.setTitle("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u9519\u8bef");
            ErrorInfo.setMessage("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u4e3a\u7a7a");
            this.operationResult.addErrorInfo(ErrorInfo);
        }
    }
}

