/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.mdritem;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.mdritem.ItemInfoAuditValidator;
import kd.drp.mdr.common.CommonUtils;

public class ItemInfoAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("barcodenumber");
        fieldKeys.add("barcode");
        fieldKeys.add("currency");
        fieldKeys.add("retailprice");
        fieldKeys.add("memberprice");
        fieldKeys.add("retailunit");
        fieldKeys.add("material");
        fieldKeys.add("materialmasterid");
        fieldKeys.add("attrname");
        fieldKeys.add("attrnumber");
        fieldKeys.add("easnumber");
        fieldKeys.add("attrvalue");
        fieldKeys.add("hasattr");
        fieldKeys.add("baseunit");
        fieldKeys.add("modelnum");
        fieldKeys.add("itemclassentity.classstandardid");
        fieldKeys.add("itemclassentity.goodsclasssid");
        fieldKeys.add("itemclass");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ItemInfoAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        this.createItemBarcode(itemDynObjs);
        DynamicObjectCollection entryItemClassColl = null;
        ArrayList<DynamicObject> itemClassObjList = null;
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject item = itemDynObjs[i];
            entryItemClassColl = item.getDynamicObjectCollection("itemclassentity");
            if (CommonUtils.isNull((Object)entryItemClassColl)) continue;
            itemClassObjList = new ArrayList<DynamicObject>(entryItemClassColl.size());
            for (DynamicObject entryClassDynObj : entryItemClassColl) {
                if (!CommonUtils.isNull((Object)entryClassDynObj.getDynamicObject("goodsclasssid"))) continue;
                itemClassObjList.add(entryClassDynObj);
            }
            for (DynamicObject itemClassObj : itemClassObjList) {
                entryItemClassColl.remove((Object)itemClassObj);
            }
            item.set("itemclassentity", (Object)entryItemClassColl);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        this.saveOrUpdateF7(itemDynObjs);
    }

    private void saveOrUpdateF7(DynamicObject[] itemDynObjs) {
        ArrayList<DynamicObject> itemcombinationList = new ArrayList<DynamicObject>(itemDynObjs.length);
        DynamicObject itemcombinationDynObj = null;
        for (DynamicObject itemDynObj : itemDynObjs) {
            itemcombinationDynObj = QueryServiceHelper.exists((String)"dpm_itemcombination_f7", (Object)itemDynObj.getPkValue()) ? BusinessDataServiceHelper.loadSingle((Object)itemDynObj.getPkValue(), (String)"dpm_itemcombination_f7") : BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemcombination_f7");
            itemcombinationDynObj.set("number", itemDynObj.get("number"));
            itemcombinationDynObj.set("name", itemDynObj.get("name"));
            itemcombinationDynObj.set("baseunit", itemDynObj.get("baseunit"));
            itemcombinationDynObj.set("modelnum", itemDynObj.get("modelnum"));
            itemcombinationDynObj.set("id", itemDynObj.getPkValue());
            itemcombinationDynObj.set("iscombination", (Object)Boolean.FALSE);
            itemcombinationList.add(itemcombinationDynObj);
        }
        SaveServiceHelper.save((DynamicObject[])itemcombinationList.toArray(new DynamicObject[0]));
    }

    private void createItemBarcode(DynamicObject[] itemDynObjs) {
        if (itemDynObjs == null || itemDynObjs.length == 0 || !itemDynObjs[0].getDataEntityType().getProperties().containsKey((Object)"barcodenumber")) {
            return;
        }
        ArrayList<DynamicObject> itemBarCodeList = new ArrayList<DynamicObject>(itemDynObjs.length);
        DynamicObject itemBarCodeDynObj = null;
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject itemDynObj = itemDynObjs[i];
            String barcodeNumber = itemDynObj.getString("barcodenumber");
            if (StringUtils.isEmpty((CharSequence)barcodeNumber)) continue;
            long barcodeId = itemDynObj.getLong("barcode");
            itemBarCodeDynObj = QueryServiceHelper.exists((String)"mdr_item_barcode", (Object)barcodeId) ? BusinessDataServiceHelper.loadSingle((Object)barcodeId, (String)"mdr_item_barcode") : BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_barcode");
            itemBarCodeDynObj.set("createorg", (Object)itemDynObj.getDynamicObject("createorg"));
            itemBarCodeDynObj.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            itemBarCodeDynObj.set("createtime", (Object)new Date());
            itemBarCodeDynObj.set("status", (Object)"C");
            itemBarCodeDynObj.set("item", (Object)itemDynObj);
            itemBarCodeDynObj.set("barcode", (Object)barcodeNumber);
            itemBarCodeDynObj.set("currency", (Object)itemDynObj.getDynamicObject("currency"));
            itemBarCodeDynObj.set("retailprice", (Object)itemDynObj.getBigDecimal("retailprice"));
            itemBarCodeDynObj.set("memberprice", (Object)itemDynObj.getBigDecimal("memberprice"));
            itemBarCodeDynObj.set("unit", (Object)itemDynObj.getDynamicObject("retailunit"));
            itemBarCodeDynObj.set("materiel", (Object)itemDynObj.getDynamicObject("material"));
            itemBarCodeList.add(itemBarCodeDynObj);
        }
        if (itemBarCodeList.size() > 0) {
            Object[] itemBarCodeDynObjs = SaveServiceHelper.save((DynamicObject[])itemBarCodeList.toArray(new DynamicObject[itemBarCodeList.size()]));
            long baracodeId = 0L;
            String baracodeNumber = "";
            long itemId = 0L;
            for (Object dynObj : itemBarCodeDynObjs) {
                baracodeId = ((DynamicObject)dynObj).getLong("id");
                baracodeNumber = ((DynamicObject)dynObj).getString("barcode");
                itemId = ((DynamicObject)dynObj).getLong("item_id");
                for (int i = 0; i < itemDynObjs.length; ++i) {
                    DynamicObject itemDynObj = itemDynObjs[i];
                    if (baracodeId <= 0L || !itemDynObj.getString("barcodenumber").equals(baracodeNumber) || itemDynObj.getLong("id") != itemId) continue;
                    itemDynObj.set("barcode", (Object)baracodeId);
                }
            }
        }
    }
}

