/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.mdritem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.mdritem.ItemInfoSaveValidator;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;

public class ItemInfoSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("barcodenumber");
        fieldKeys.add("barcode");
        fieldKeys.add("mulowner");
        fieldKeys.add("owner");
        fieldKeys.add("currency");
        fieldKeys.add("retailprice");
        fieldKeys.add("memberprice");
        fieldKeys.add("retailunit");
        fieldKeys.add("material");
        fieldKeys.add("materialmasterid");
        fieldKeys.add("attrname");
        fieldKeys.add("attrnumber");
        fieldKeys.add("easnumber");
        fieldKeys.add("attrvalue");
        fieldKeys.add("hasattr");
        fieldKeys.add("itemclassentity.classstandardid");
        fieldKeys.add("itemclassentity.goodsclasssid");
        fieldKeys.add("itemclass");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ItemInfoSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List dataList = e.getValidExtDataEntities();
        DynamicObject item = null;
        DynamicObject material = null;
        for (ExtendedDataEntity data : dataList) {
            item = data.getDataEntity();
            material = item.getDynamicObject("material");
            if (material == null) continue;
            Object materialMasterId = material.get("masterid");
            item.set("materialmasterid", materialMasterId);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        DynamicObject goodsClassDynObj = null;
        DynamicObject classStandardDynObj = null;
        DynamicObjectCollection entryMulOwner = null;
        DynamicObject owner = null;
        DynamicObjectCollection entryItemClassColl = null;
        ArrayList<DynamicObject> itemClassObjList = null;
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject item = itemDynObjs[i];
            entryItemClassColl = item.getDynamicObjectCollection("itemclassentity");
            if (!CommonUtils.isNull((Object)entryItemClassColl)) {
                itemClassObjList = new ArrayList<DynamicObject>(entryItemClassColl.size());
                for (DynamicObject entryClassDynObj : entryItemClassColl) {
                    if (CommonUtils.isNull((Object)entryClassDynObj.getDynamicObject("goodsclasssid"))) continue;
                    itemClassObjList.add(entryClassDynObj);
                    classStandardDynObj = entryClassDynObj.getDynamicObject("classstandardid");
                    if (classStandardDynObj.getLong("id") == 1L) {
                        goodsClassDynObj = entryClassDynObj.getDynamicObject("goodsclasssid");
                    }
                    if (goodsClassDynObj != null) continue;
                    goodsClassDynObj = entryClassDynObj.getDynamicObject("goodsclasssid");
                }
                entryItemClassColl.clear();
                for (DynamicObject itemClassObj : itemClassObjList) {
                    entryItemClassColl.add((Object)itemClassObj);
                }
                item.set("itemclassentity", (Object)entryItemClassColl);
            }
            item.set("itemclass", goodsClassDynObj);
            owner = item.getDynamicObject("owner");
            if (owner != null && !StringUtils.isEmpty((String)owner.getString("number"))) continue;
            entryMulOwner = item.getDynamicObjectCollection("mulowner");
            item.set("owner", ((DynamicObject)entryMulOwner.get(0)).get("fbasedataid"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        HashSet<Object> itemIdSet = new HashSet<Object>();
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject item = itemDynObjs[i];
            boolean hasattr = item.getBoolean("hasattr");
            if (hasattr) {
                this.saveAttrVaule(item);
                continue;
            }
            itemIdSet.add(item.getPkValue());
        }
        if (itemIdSet.size() > 0) {
            QFilter q = new QFilter("item", "in", itemIdSet);
            DeleteServiceHelper.delete((String)"mdr_item_attrvalue", (QFilter[])q.toArray());
        }
    }

    private void saveAttrVaule(DynamicObject item) {
        Iterator attrvalueId;
        DynamicObjectCollection attrEntry = item.getDynamicObjectCollection("attrvalueentry");
        DynamicObjectCollection itemAttrs = item.getDynamicObjectCollection("attrentry");
        int attrsSize = 0;
        if (itemAttrs != null) {
            attrsSize = itemAttrs.size();
        }
        HashSet attrvalueIds = new HashSet();
        ArrayList<DynamicObject> newItemAttrvalues = new ArrayList<DynamicObject>();
        ArrayList oldItemAttrvalues = new ArrayList();
        int seq = 0;
        for (DynamicObject attrs : attrEntry) {
            DynamicObject attrvalue = attrs.getDynamicObject("attrvalue");
            if (attrvalue == null) continue;
            attrvalueId = attrvalue.get("id");
            attrvalueIds.add(attrvalueId);
        }
        QFilter qFilter = new QFilter("id", "in", attrvalueIds);
        DynamicObject[] itemAttrvalues = BusinessDataServiceHelper.load((String)"mdr_item_attrvalue", (String)"id,attrseq,easnumber,attrentity.attrvalue,attrentity.seq", (QFilter[])qFilter.toArray());
        if (itemAttrvalues != null && itemAttrvalues.length > 0) {
            List<DynamicObject> itemAttrvalueList = Arrays.asList(itemAttrvalues);
            attrvalueId = itemAttrvalueList.iterator();
            while (attrvalueId.hasNext()) {
                DynamicObject itemAttrvalue = (DynamicObject)attrvalueId.next();
                itemAttrvalue.set("attrseq", (Object)(++seq));
                itemAttrvalue.set("easnumber", (Object)"easnumber");
            }
            oldItemAttrvalues.addAll(itemAttrvalueList);
        }
        for (DynamicObject attrs : attrEntry) {
            String attrName = attrs.getString("attrname");
            String attrNumber = attrs.getString("attrnumber");
            String easNumber = attrs.getString("easnumber");
            DynamicObject attrvalue = attrs.getDynamicObject("attrvalue");
            if (attrvalue != null) {
                for (DynamicObject oldItemAttrvalue : oldItemAttrvalues) {
                    if (!oldItemAttrvalue.getPkValue().equals(attrvalue.getPkValue()) || attrName.compareTo(oldItemAttrvalue.getString("name")) == 0) continue;
                    oldItemAttrvalue.set("name", (Object)attrName);
                    oldItemAttrvalue.set("number", (Object)attrNumber);
                    DynamicObjectCollection attrentity = oldItemAttrvalue.getDynamicObjectCollection("attrentity");
                    attrentity.clear();
                    for (int i = 0; i < attrsSize; ++i) {
                        DynamicObject attr = attrentity.addNew();
                        attr.set("attrvalue", attrs.get("attrvalue" + (i + 1)));
                        attr.set("seq", (Object)i);
                    }
                }
                continue;
            }
            ++seq;
            DynamicObject itemAttrvalue = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue");
            itemAttrvalue.set("name", (Object)attrName);
            itemAttrvalue.set("number", (Object)attrNumber);
            itemAttrvalue.set("easnumber", (Object)easNumber);
            itemAttrvalue.set("item", item.get("id"));
            itemAttrvalue.set("attrseq", (Object)seq);
            DynamicObjectCollection attrentity = itemAttrvalue.getDynamicObjectCollection("attrentity");
            for (int i = 0; i < attrsSize; ++i) {
                DynamicObject attr = attrentity.addNew();
                attr.set("attrvalue", attrs.get("attrvalue" + (i + 1)));
                attr.set("seq", (Object)i);
            }
            newItemAttrvalues.add(itemAttrvalue);
        }
        if (attrvalueIds.size() > 0 || newItemAttrvalues.size() > 0) {
            QFilter q = new QFilter("item", "=", item.get("id"));
            q.and("id", "not in", attrvalueIds);
            DeleteServiceHelper.delete((String)"mdr_item_attrvalue", (QFilter[])q.toArray());
        }
        if (newItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newItemAttrvalues.toArray(new DynamicObject[0]));
        }
        if (oldItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])oldItemAttrvalues.toArray(new DynamicObject[0]));
        }
    }
}

