/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.member;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.opplugin.member.Common;

public class OnLineCommonOp
extends AbstractOperationServicePlugIn {
    private boolean isRegisted = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("onisaudit");
        e.getFieldKeys().add("onisenable");
        e.getFieldKeys().add("isregisted");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("phonenumber");
        e.getFieldKeys().add("vipcertificate_entry");
        e.getFieldKeys().add("vipcertificate_entry,idtypeid");
        e.getFieldKeys().add("vipcertificate_entry,certificatenumber");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opKey;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        switch (opKey = e.getOperationKey()) {
            case "save": 
            case "submit": {
                this.isRegisted = Arrays.stream(dataEntities).anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isregisted"));
                Common.update(dataEntities, "isregisted", Boolean.FALSE);
                Common.updatePkValue(dataEntities);
                break;
            }
            case "audit": {
                Common.update(dataEntities, "onisaudit", Boolean.TRUE);
                break;
            }
            case "unaudit": {
                Common.update(dataEntities, "onisaudit", Boolean.FALSE);
                break;
            }
            case "enable": {
                Common.update(dataEntities, "onisenable", Boolean.TRUE);
                break;
            }
            case "disable": {
                Common.update(dataEntities, "onisenable", Boolean.FALSE);
                break;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        String opKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"save") || StringUtils.equals((CharSequence)opKey, (CharSequence)"submit")) {
            this.synchronousData(dataEntities);
        }
    }

    private void synchronousData(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> lstRelation = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> lstMemberOff = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject memberOff;
            DynamicObject user = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"creator");
            if (user == null) {
                user = Common.getUser();
            }
            DynamicObjectCollection vipCertificateEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"vipcertificate_entry");
            DynamicObject certificate = vipCertificateEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"idtypeid") == 749865059525597184L).findFirst().orElse(null);
            long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
            DynamicObject memberRelation = Common.synchronousRelation(dataEntity, certificate, pkValue, user);
            lstRelation.add(memberRelation);
            if (!this.isRegisted || (memberOff = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"dbd_member_f")) != null) continue;
            memberOff = Common.synchronousMemberOff(dataEntity, pkValue, user);
            lstMemberOff.add(memberOff);
        }
        Common.synchronousData(lstMemberOff, "dbd_member_f");
        Common.synchronousData(lstRelation, "dbd_member_relation");
    }
}

