/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.orderquantity;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.cache.model.ItemSaleInfo;
import kd.drp.mdr.common.cache.model.PathSaleInfo;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.opplugin.ImportCache;
import kd.drp.mdr.opplugin.handle.ImportHandle;

public class OrderQuantityRuleImport
implements IImportPlugin {
    private ImportHandle handle = new ImportHandle();
    private final ImportCache cache = new ImportCache();
    private PathSaleInfo rules;
    private ItemSaleInfo info;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        CheckResult result = this.checkImportData(data);
        if (result.isSuccess()) {
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(result.getMsg()));
        return false;
    }

    public void init(Map<String, Object> importParams) {
    }

    private CheckResult checkImportData(Map<String, Object> data) {
        try {
            String ownerNumber = this.handle.getNumber(data, "owner");
            if (StringUtils.isEmpty((String)ownerNumber)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"owner(\u9500\u552e\u6e20\u9053)\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrderQuantityRuleImport_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
            Object ownerId = this.handle.queryMyOwnerId(ownerNumber);
            if (ownerId == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053owner\u3010%s\u3011\u4e0d\u5c5e\u4e8e\u7528\u6237\u6240\u5c5e\u6e20\u9053", (String)"OrderQuantityRuleImport_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber});
            }
            CheckResult result = this.checkThreeChooseOne(data);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkTwoChooseOne(data);
            if (!result.isSuccess()) {
                return result;
            }
            QFilter fs = new QFilter("owner", "=", ownerId);
            result = this.checkWareHouse(data, ownerNumber, ownerId, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkCustomer(data, ownerNumber, ownerId, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkItem(data, ownerNumber, ownerId, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkItemClass(data, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkItemClass(data, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkAssistAttr(data, fs);
            if (!result.isSuccess()) {
                return result;
            }
            boolean exists = QueryServiceHelper.exists((String)"mdr_orderquantity", (QFilter[])fs.toArray());
            if (exists) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u89c4\u5219\u5df2\u5b58\u5728,\u65e0\u9700\u5bfc\u5165", (String)"OrderQuantityRuleImport_2", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return CheckResult.returnFalse((String)e.getMessage());
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkThreeChooseOne(Map<String, Object> data) {
        int result = this.checkTreeeChooseOne(data);
        if (result == 0 || result == 1) {
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053\u3001\u6e20\u9053\u5206\u7ec4\u3001\u533a\u57df\u6700\u591a\u9009\u62e9\u4e00\u9879\u5f55\u5165", (String)"OrderQuantityRuleImport_3", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
    }

    private int checkTreeeChooseOne(Map<String, Object> data) {
        String customerNumber = this.handle.getNumber(data, "customer");
        int customerTemp = 0;
        String regionNumber = this.handle.getNumber(data, "region");
        int regionTemp = 0;
        String customerGroupNumber = this.handle.getNumber(data, "customergroup");
        int customerGroupTemp = 0;
        if (!StringUtils.isEmpty((String)customerNumber)) {
            customerTemp = 1;
        }
        if (!StringUtils.isEmpty((String)regionNumber)) {
            regionTemp = 1;
        }
        if (!StringUtils.isEmpty((String)customerGroupNumber)) {
            customerGroupTemp = 1;
        }
        return customerTemp + regionTemp + customerGroupTemp;
    }

    private CheckResult checkTwoChooseOne(Map<String, Object> data) {
        int result;
        String itemNumber = this.handle.getNumber(data, "item");
        int itemTemp = 0;
        String itemClassNumber = this.handle.getNumber(data, "itemclass");
        int itemClassTemp = 0;
        if (!StringUtils.isEmpty((String)itemNumber)) {
            itemTemp = 1;
        }
        if (!StringUtils.isEmpty((String)itemClassNumber)) {
            itemClassTemp = 1;
        }
        if ((result = itemTemp + itemClassTemp) == 1) {
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3001\u5546\u54c1\u5206\u7c7b\u9700\u9009\u62e9\u4e00\u9879\u5f55\u5165", (String)"OrderQuantityRuleImport_4", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
    }

    private CheckResult checkWareHouse(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String warehouseNumber = this.handle.getNumber(data, "warehouse");
        if (!StringUtils.isEmpty((String)warehouseNumber)) {
            Object warehouseId = this.cache.getWareHouseIdFromCache(warehouseNumber);
            if (warehouseId == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u53d1\u8d27\u5730\u70b9warehouse\u3010%s\u3011\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728", (String)"OrderQuantityRuleImport_5", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{warehouseNumber});
            }
            if (!BizValidateUtils.customerHasWarehouse((Object)ownerId, (Object)warehouseId)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010 %s\u3011\u4e0b\u4e0d\u5b58\u5728\u6388\u6743\u7684\u53d1\u8d27\u5730\u70b9\u3010%s\u3011", (String)"OrderQuantityRuleImport_6", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, warehouseNumber});
            }
            fs.and("warehouse", "=", warehouseId);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkCustomer(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String customerNumber = this.handle.getNumber(data, "customer");
        if (StringUtils.isEmpty((String)customerNumber)) {
            return this.checkRegion(data, ownerNumber, ownerId, fs);
        }
        Object customerId = this.cache.getCustomerIdFromCache(customerNumber);
        if (customerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053owner\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"OrderQuantityRuleImport_7", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customerNumber});
        }
        if (!this.handle.isAuthRelation(ownerId, customerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u8ba2\u8d27\u6e20\u9053\u3010%s\u3011", (String)"OrderQuantityRuleImport_8", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, customerNumber});
        }
        fs.and("customer", "=", customerId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkRegion(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String regionNumber = this.handle.getNumber(data, "region");
        if (StringUtils.isEmpty((String)regionNumber)) {
            return this.checkCustomerGroup(data, ownerNumber, ownerId, fs);
        }
        Object regionId = this.cache.getRegionIdFromCache(regionNumber, ownerId);
        if (regionId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u533a\u57df\u3010%s\u3011", (String)"OrderQuantityRuleImport_9", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, regionNumber});
        }
        fs.and("region", "=", regionId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkCustomerGroup(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String groupNumber = this.handle.getNumber(data, "customergroup");
        if (StringUtils.isEmpty((String)groupNumber)) {
            return CheckResult.returnTrue();
        }
        Object groupId = this.cache.getcustomerGroupIdFromCache(groupNumber, ownerId);
        if (groupId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6e20\u9053\u5206\u7ec4\u3010%s\u3011", (String)"OrderQuantityRuleImport_10", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{groupNumber});
        }
        fs.and("customergroup", "=", groupId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkItem(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String itemNumber = this.handle.getNumber(data, "item");
        Object itemId = this.cache.getItemIdFromCache(itemNumber);
        if (!this.checkCanSale(itemId, ownerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u53ef\u9500\u5546\u54c1\u3010%s\u3011", (String)"OrderQuantityRuleImport_11", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, itemNumber});
        }
        fs.and("item", "=", itemId);
        return CheckResult.returnTrue();
    }

    private boolean checkCanSale(Object itemId, Object ownerId) {
        PathSaleInfo rules = this.getPathSaleInfo(ownerId);
        if (rules == null) {
            return false;
        }
        return rules.isItemCanSale(itemId);
    }

    private PathSaleInfo getPathSaleInfo(Object ownerId) {
        PathSaleInfo rules = null;
        if (ownerId == null) {
            rules = this.rules;
        } else {
            ItemSaleInfo localInfo = this.getItemSaleInfo();
            rules = localInfo.querySaleRules(ownerId);
            rules.addCustomerItemIds(ownerId);
            this.rules = rules;
        }
        return rules;
    }

    private ItemSaleInfo getItemSaleInfo() {
        if (this.info == null) {
            this.info = new ItemSaleInfo();
        }
        return this.info;
    }

    private CheckResult checkItemClass(Map<String, Object> data, QFilter fs) {
        String itemClassNumber = this.handle.getNumber(data, "itemclass");
        if (!StringUtils.isEmpty((String)itemClassNumber)) {
            Object itemClassId = this.cache.getItemClassIdFromCache(itemClassNumber);
            if (itemClassId == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7bitemclass\u3010%s\u3011\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728", (String)"OrderQuantityRuleImport_12", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{itemClassNumber});
            }
            fs.and("itemclass", "=", itemClassId);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkAssistAttr(Map<String, Object> data, QFilter fs) {
        String assistAttrNumber = this.handle.getNumber(data, "assistattr");
        if (!StringUtils.isEmpty((String)assistAttrNumber)) {
            Object assistAttrId = this.cache.getAssistAttrIdFromCache(assistAttrNumber);
            String itemNumber = this.handle.getNumber(data, "item");
            Object itemId = this.cache.getItemIdFromCache(itemNumber);
            if (assistAttrId == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u8f85\u52a9\u5c5e\u6027assistattr\u3010%s\u3011\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728", (String)"OrderQuantityRuleImport_13", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{assistAttrNumber});
            }
            if (!this.checkItemAttr(itemId, assistAttrId)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1item\u3010%s\u3011\u6ca1\u6709\u7ef4\u62a4\u8f85\u52a9\u5c5e\u6027\u503c\u3010%s\u3011", (String)"OrderQuantityRuleImport_14", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{itemNumber, assistAttrNumber});
            }
            fs.and("assistattr", "=", assistAttrId);
        }
        return CheckResult.returnTrue();
    }

    private boolean checkItemAttr(Object itemId, Object assistAttrId) {
        Set attrIds = ItemAttrUtil.getAttrIds((Object)itemId);
        return attrIds.contains(assistAttrId);
    }
}

