/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.param;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerParamsSaveOpPlugin
extends MdrBaseOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        if ("save".equals(key)) {
            DynamicObject[] dyObejcts = e.getDataEntities();
            DynamicObject dyObject = dyObejcts[0];
            StringBuilder sb = new StringBuilder();
            String regex = "^,*|,*$";
            DynamicObjectCollection collection = dyObject.getDynamicObjectCollection("timeentity");
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                boolean isAfter;
                DynamicObject timeObject = (DynamicObject)collection.get(i);
                Date startDate = timeObject.getDate("starttime");
                Date endDate = timeObject.getDate("endtime");
                Instant startInstant = startDate.toInstant();
                Instant endInstant = endDate.toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime startDateTime = LocalDateTime.ofInstant(startInstant, zone);
                LocalDateTime endDateTime = LocalDateTime.ofInstant(endInstant, zone);
                LocalTime startTime = startDateTime.toLocalTime();
                LocalTime endTime = endDateTime.toLocalTime();
                if (startTime != null && endTime != null && !(isAfter = endTime.isAfter(startTime))) {
                    e.cancel = true;
                    e.setCancelMessage(ResManager.loadKDString((String)"\u65f6\u95f4\u5206\u5f55\u4e2d\u7684\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"CustomerParamsSaveOpPlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
                    return;
                }
                String operationName = timeObject.getString("operation");
                boolean isuse = timeObject.getBoolean("isuse");
                if (!StringUtils.isNotEmpty((String)operationName) || !isuse) continue;
                operationName = operationName.replaceAll(regex, "");
                if (i != size - 1) {
                    sb.append(operationName).append(',');
                    continue;
                }
                sb.append(operationName);
            }
            String[] operationNames = sb.toString().split(",");
            boolean isExitSame = CustomerParamsSaveOpPlugin.checkRepeat(operationNames);
            if (isExitSame) {
                e.cancel = true;
                e.setCancelMessage(ResManager.loadKDString((String)"\u65f6\u95f4\u5206\u5f55\u4e2d\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7684\u5df2\u542f\u7528\u7684\u64cd\u4f5c\u9879", (String)"CustomerParamsSaveOpPlugin_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public static boolean checkRepeat(String[] array) {
        HashSet<String> set = new HashSet<String>(array.length);
        for (String str : array) {
            set.add(str);
        }
        return set.size() != array.length;
    }
}

