/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.payconfig;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.opplugin.payconfig.Validator;

public class PayConfigSavePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.channel");
        e.getFieldKeys().add("entryentity.isservicefirm");
        e.getFieldKeys().add("entryentity.subentryentity");
        e.getFieldKeys().add("subentryentity.Seq");
        e.getFieldKeys().add("subentryentity.param");
        e.getFieldKeys().add("subentryentity.paramkey");
        e.getFieldKeys().add("subentryentity.ismustinput");
        e.getFieldKeys().add("subentryentity.paramvalue");
        e.getFieldKeys().add("subentryentity.isattach");
        e.getFieldKeys().add("subentryentity.attachment");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("treeentryentity.branch");
        e.getFieldKeys().add("treeentryentity.Seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length <= 0) {
            return;
        }
        for (DynamicObject data : datas) {
            long id = data.getLong("Id");
            DynamicObjectCollection entryData = null;
            if (DynamicObjectUtils.contain((DynamicObject)data, (String)"entryentity")) {
                entryData = data.getDynamicObjectCollection("entryentity");
            }
            if (entryData == null || entryData.size() <= 0) continue;
            for (DynamicObject item : entryData) {
                long entryId = item.getLong("Id");
                boolean isServiceFirm = DynamicObjectUtils.contain((DynamicObject)item, (String)"isservicefirm") && item.getBoolean("isservicefirm");
                DynamicObjectCollection subEntryData = null;
                if (DynamicObjectUtils.contain((DynamicObject)item, (String)"subentryentity")) {
                    subEntryData = item.getDynamicObjectCollection("subentryentity");
                }
                if (subEntryData == null || subEntryData.size() <= 0) continue;
                boolean isExit = this.checkHasServiceFirm(id, entryId);
                if (isExit) {
                    subEntryData.forEach(p -> {
                        long paramId;
                        DynamicObject param = p.getDynamicObject("param");
                        long l = paramId = param == null ? 0L : param.getLong("Id");
                        if (paramId == 923679825657337856L) {
                            p.set("paramvalue", (Object)(isServiceFirm ? "1" : "0"));
                        }
                    });
                    continue;
                }
                DynamicObjectType type = subEntryData.getDynamicObjectType();
                DynamicObject newSubItem = new DynamicObject(type);
                DynamicObject param = BusinessDataServiceHelper.loadSingle((Object)923679825657337856L, (String)"dbd_payparam");
                if (param == null) continue;
                newSubItem.set("Seq", (Object)(subEntryData.size() + 1));
                newSubItem.set("param", (Object)param);
                newSubItem.set("paramkey", (Object)(!DynamicObjectUtils.contain((DynamicObject)param, (String)"number") ? "isservicefirm" : param.getString("number")));
                newSubItem.set("ismustinput", (Object)Boolean.TRUE);
                newSubItem.set("paramvalue", (Object)(isServiceFirm ? "1" : "0"));
                newSubItem.set("isattach", (Object)Boolean.FALSE);
                subEntryData.add((Object)newSubItem);
            }
        }
    }

    private boolean checkHasServiceFirm(long id, long entryId) {
        QFilter filter = new QFilter("Id", "=", (Object)id);
        filter.and("entryentity.Id", "=", (Object)entryId);
        filter.and("entryentity.subentryentity.param.Id", "=", (Object)923679825657337856L);
        return QueryServiceHelper.exists((String)"dbd_payconfigs", (QFilter[])filter.toArray());
    }
}

