/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.payconfig;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.enums.ControlModeEnum;

public class Validator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        if (datas == null || datas.length <= 0) {
            return;
        }
        for (ExtendedDataEntity data : datas) {
            DynamicObject item = data.getDataEntity();
            String controlmode = item.getString("controlmode");
            DynamicObjectCollection treeentryentities = item.getDynamicObjectCollection("treeentryentity");
            if (ControlModeEnum.ASSIGNSTORE.getValue().equals(controlmode) && (treeentryentities == null || treeentryentities.size() == 0)) {
                this.addErrorMessage(data, "\u95e8\u5e97\u63a7\u5236\u65b9\u5f0f\u4e3a\u6307\u5b9a\u95e8\u5e97\u65f6,\u95e8\u5e97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            DynamicObjectCollection entities = item.getDynamicObjectCollection("entryentity");
            long payConfigId = item.getLong("Id");
            if (entities == null || entities.size() <= 0) continue;
            for (DynamicObject entity : entities) {
                long payChannelId;
                DynamicObject channel = entity.getDynamicObject("channel");
                if (channel == null) {
                    this.addErrorMessage(data, "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                String channelName = channel.getString("Name");
                boolean isExsitBranchPayConfig = this.checkPayConfig(data, treeentryentities, channelName, payChannelId = channel.getLong("Id"), payConfigId);
                if (isExsitBranchPayConfig) {
                    return;
                }
                DynamicObjectCollection subEntities = entity.getDynamicObjectCollection("subentryentity");
                if (subEntities == null || subEntities.size() <= 0) continue;
                for (DynamicObject subEntity : subEntities) {
                    DynamicObject param = subEntity.getDynamicObject("param");
                    String paramName = param.getString("Name");
                    int seq = subEntity.getInt("Seq");
                    boolean mustInput = subEntity.getBoolean("ismustinput");
                    String value = subEntity.getString("paramvalue");
                    if (mustInput && StringUtils.isBlank((CharSequence)value)) {
                        String format = "\u7ed3\u7b97\u65b9\u5f0f\u3010%s\u3011\u7b2c%d\u884c\u652f\u4ed8\u53c2\u6570\u3010%s\u3011\u4e3a\u5fc5\u5f55\u9879\uff0c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a";
                        this.addErrorMessage(data, String.format(format, channelName, seq, paramName));
                        return;
                    }
                    boolean isAttach = subEntity.getBoolean("isattach");
                    DynamicObjectCollection attachCollection = subEntity.getDynamicObjectCollection("attachment");
                    if (!isAttach || attachCollection != null && attachCollection.size() != 0) continue;
                    String format = "\u7ed3\u7b97\u65b9\u5f0f\u3010%s\u3011\u7b2c%d\u884c\uff0c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
                    this.addErrorMessage(data, String.format(format, channelName, seq));
                    return;
                }
            }
        }
    }

    private boolean checkPayConfig(ExtendedDataEntity data, DynamicObjectCollection treeentryentities, String channelName, long payChannelId, long payConfigId) {
        boolean isExsitBranchPayConfig = false;
        isExsitBranchPayConfig = this.checkIsExsitPayConfig(payChannelId, 0L, payConfigId);
        if (isExsitBranchPayConfig) {
            String format = "\u7ed3\u7b97\u65b9\u5f0f\u3010%s\u3011\u5df2\u5b58\u5728\u9002\u7528\u6240\u6709\u95e8\u5e97\u7684\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5";
            this.addErrorMessage(data, String.format(format, channelName));
            return isExsitBranchPayConfig;
        }
        if (treeentryentities != null && treeentryentities.size() > 0) {
            for (DynamicObject treeentryentity : treeentryentities) {
                DynamicObject branchInfo = treeentryentity.getDynamicObject("branch");
                int seq = treeentryentity.getInt("Seq");
                long branchlId = branchInfo.getLong("Id");
                String branchName = branchInfo.getString("Name");
                isExsitBranchPayConfig = this.checkIsExsitPayConfig(payChannelId, branchlId, payConfigId);
                if (!isExsitBranchPayConfig) continue;
                String format = "\u7b2c%d\u884c\u95e8\u5e97\u4fe1\u606f\u3010%s\u3011\u5df2\u5b58\u5728\u7ed3\u7b97\u65b9\u5f0f\u3010%s\u3011\u7684\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5";
                this.addErrorMessage(data, String.format(format, seq, branchName, channelName));
                return isExsitBranchPayConfig;
            }
        } else {
            isExsitBranchPayConfig = this.checkIsExsitPayConfig(payChannelId, -1L, payConfigId);
            if (isExsitBranchPayConfig) {
                String format = "\u7ed3\u7b97\u65b9\u5f0f\u3010%s\u3011\u5df2\u5b58\u5728\u9002\u7528\u6307\u5b9a\u95e8\u5e97\u7684\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u518d\u9002\u7528\u6240\u6709\u95e8\u5e97\uff0c\u8bf7\u68c0\u67e5";
                this.addErrorMessage(data, String.format(format, channelName));
                return isExsitBranchPayConfig;
            }
        }
        return isExsitBranchPayConfig;
    }

    private boolean checkIsExsitPayConfig(long payChannelId, long branchlId, long payConfigId) {
        QFilter filter = new QFilter("entryentity.channel.Id", "=", (Object)payChannelId);
        if (payConfigId > 0L) {
            filter.and("Id", "!=", (Object)payConfigId);
        }
        if (branchlId > 0L) {
            filter.and("treeentryentity.branch.Id", "=", (Object)branchlId);
        } else if (branchlId == 0L) {
            filter.and("controlmode", "=", (Object)ControlModeEnum.ALLSTORE.getValue());
        } else {
            filter.and("controlmode", "=", (Object)ControlModeEnum.ASSIGNSTORE.getValue());
        }
        return QueryServiceHelper.exists((String)"dbd_payconfigs", (QFilter[])filter.toArray());
    }
}

