/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.receipt;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ReceiptSavePlugin
extends MdrBaseOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        CheckResult checkCanSave = null;
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            checkCanSave = this.checkCanSave(datas[i]);
            if (checkCanSave.isSuccess()) continue;
            e.cancel = true;
            e.setCancelMessage(checkCanSave.getMsg());
            return;
        }
    }

    private CheckResult checkCanSave(DynamicObject data) {
        boolean exists;
        QFilter f = new QFilter("customer", "=", data.get("customer_id")).and("taxnum", "=", data.get("taxnum")).and("taxtype", "=", data.get("taxtype"));
        if (!DynamicObjectUtils.isNewCreate((DynamicObject)data)) {
            f.and("id", "!=", data.get("id"));
        }
        if (exists = QueryServiceHelper.exists((String)"mdr_receipt", (QFilter[])f.toArray())) {
            return CheckResult.returnFalse((String)this.getExistMsg(data));
        }
        return CheckResult.returnTrue();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        boolean isDefault = false;
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            isDefault = datas[i].getBoolean("default");
            if (!isDefault) continue;
            this.setUnDefault(datas[i]);
        }
    }

    private void setUnDefault(DynamicObject data) {
        QFilter f = new QFilter("customer", "=", data.get("customer_id")).and("id", "!=", data.get("id"));
        DynamicObject[] allInfo = BusinessDataServiceHelper.load((String)"mdr_receipt", (String)"id,default", (QFilter[])f.toArray());
        int len = allInfo.length;
        for (int i = 0; i < len; ++i) {
            allInfo[i].set("default", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])allInfo);
    }

    private String getExistMsg(DynamicObject data) {
        StringBuilder msg = new StringBuilder();
        DynamicObject customer = data.getDynamicObject("customer");
        msg.append(ResManager.loadKDString((String)"\u3010\u6e20\u9053\uff1a", (String)"ReceiptSavePlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0])).append(customer.get("name")).append('\u3011').append(ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a", (String)"ReceiptSavePlugin_1", (String)"drp-dbd-opplugin", (Object[])new Object[0])).append(data.get("taxnum")).append(ResManager.loadKDString((String)",\u5f00\u7968\u7c7b\u578b\uff1a", (String)"ReceiptSavePlugin_2", (String)"drp-dbd-opplugin", (Object[])new Object[0])).append(this.getTaxType(data.getInt("taxtype"))).append(ResManager.loadKDString((String)"\u7684\u5f00\u7968\u4fe1\u606f\u5df2\u5b58\u5728", (String)"ReceiptSavePlugin_3", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        return msg.toString();
    }

    private String getTaxType(int type) {
        switch (type) {
            case 1: {
                return "\u666e\u901a\u53d1\u7968";
            }
            case 2: {
                return "\u666e\u901a\u53d1\u7968";
            }
            case 3: {
                return "\u7535\u5b50\u53d1\u7968";
            }
        }
        return null;
    }
}

