/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.region;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.opplugin.ImportCache;
import kd.drp.mdr.opplugin.handle.ImportHandle;

public class RegionUserImportPlugin
implements IImportPlugin {
    private ImportHandle handle = new ImportHandle();
    private final ImportCache cache = new ImportCache();
    private Map<Object, Map<String, Object>> userMapCache;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        CheckResult result = this.checkImportData(data);
        if (result.isSuccess()) {
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(result.getMsg()));
        return false;
    }

    private CheckResult checkImportData(Map<String, Object> data) {
        String ownerNumber = this.handle.getNumber(data, "owner");
        Object ownerId = null;
        if (StringUtils.isEmpty((String)ownerNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RegionUserImportPlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        ownerId = this.handle.queryMyOwnerId(ownerNumber);
        if (ownerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053myowner\u3010%s\u3011\u4e0d\u662f\u5f53\u524d\u7528\u6237\u6240\u5c5e\u6e20\u9053", (String)"RegionUserImportPlugin_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber});
        }
        QFilter fs = new QFilter("owner", "=", ownerId);
        CheckResult result = this.checkRegion(data, ownerNumber, ownerId, fs);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.checkUser(data, ownerNumber, ownerId, fs);
        if (!result.isSuccess()) {
            return result;
        }
        boolean isExists = QueryServiceHelper.exists((String)"mdr_region_user_relation", (QFilter[])fs.toArray());
        if (isExists) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u65e0\u9700\u5bfc\u5165", (String)"RegionUserImportPlugin_2", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private CheckResult checkUser(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String userNumber = this.handle.getNumber(data, "user");
        if (StringUtils.isEmpty((String)userNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RegionUserImportPlugin_3", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        Object userId = this.queryUserId(userNumber, ownerId);
        if (userId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053\u3010%s\u3011\u4e0b\uff0c\u7528\u6237\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"RegionUserImportPlugin_4", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, userNumber});
        }
        fs.and("user", "=", userId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkRegion(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String regionNumber = this.handle.getNumber(data, "region");
        if (StringUtils.isEmpty((String)regionNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (String)"RegionUserImportPlugin_5", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        Object regionId = this.cache.getRegionIdFromCache(regionNumber, ownerId);
        if (regionId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u533a\u57df\u3010%s\u3011", (String)"RegionUserImportPlugin_6", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber, regionNumber});
        }
        fs.and("region", "=", regionId);
        return CheckResult.returnTrue();
    }

    private Object queryUserId(String userNumber, Object ownerId) {
        Map<String, Object> users;
        if (this.userMapCache == null) {
            this.userMapCache = new HashMap<Object, Map<String, Object>>();
        }
        if ((users = this.userMapCache.get(ownerId)) == null) {
            users = this.initOwnerUserMap(ownerId);
            this.userMapCache.clear();
            this.userMapCache.put(ownerId, users);
        }
        return users.get(userNumber);
    }

    private Map<String, Object> initOwnerUserMap(Object ownerId) {
        QFilter fs = new QFilter("enable", "=", (Object)"1");
        fs.and("owner", "=", ownerId);
        Map infos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (String)"sysuser", (QFilter[])fs.toArray());
        HashMap<String, Object> userMap = new HashMap<String, Object>(16);
        DynamicObject sysUser = null;
        for (DynamicObject drpUser : infos.values()) {
            sysUser = drpUser.getDynamicObject("sysuser");
            userMap.put(sysUser.getString("number"), sysUser.getPkValue());
        }
        return userMap;
    }
}

