/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.salecontrol;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleControlRuleSaveOP
extends MdrBaseOperationServicePlugIn {
    private static final String ENTRY_NAME = "tbrule";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String CREATE_TIME = "createtime";
    private static final String CREATOR = "creator";
    private static final String[] RULEIDCOLS = new String[]{"customer", "customergroup", "region", "item", "itemclass"};
    private static final String[] RULECOLS = new String[]{"region", "item", "itemclass", "cansale"};
    private static final String[] MDRITEMSALECONTROL = new String[]{"item", "itemclass", "region"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("customer");
        fieldKeys.add("customergroup");
        fieldKeys.add("owner");
        fieldKeys.add("item");
        fieldKeys.add("region");
        fieldKeys.add("itemclass");
        fieldKeys.add("cansale");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] saleControlRules = e.getDataEntities();
        DynamicObject saleRule = saleControlRules[0];
        DynamicObjectCollection ruleCollection = saleRule.getDynamicObjectCollection(ENTRY_NAME);
        if (ruleCollection != null && ruleCollection.size() > 0) {
            int size = ruleCollection.size();
            Set<String> idSet = this.queryRuleUnique(saleRule);
            String idFlag = null;
            Map<String, Object> createInfos = this.getCommonCreateInfos();
            ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>(size);
            for (DynamicObject scRule : ruleCollection) {
                idFlag = this.getEffectiveString(scRule);
                if (idFlag == null || idSet.contains(idFlag)) continue;
                rules.add(this.createRuleInfo(scRule, saleRule, createInfos));
            }
            size = rules.size();
            if (size == 0) {
                return;
            }
            DynamicObject[] ruleArr = new DynamicObject[size];
            for (int i = 0; i < size; ++i) {
                ruleArr[i] = (DynamicObject)rules.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])ruleArr);
        }
    }

    private Set<String> queryRuleUnique(DynamicObject rule) {
        DynamicObject owner = rule.getDynamicObject("owner");
        QFilter fs = new QFilter("owner", "=", owner.get("id"));
        DynamicObjectCollection dbInfos = QueryServiceHelper.query((String)"mdr_salecontrol", (String)"customer,customergroup,region,item,itemclass", (QFilter[])fs.toArray());
        HashSet<String> ids = new HashSet<String>();
        for (DynamicObject info : dbInfos) {
            ids.add(this.getIds(info));
        }
        return ids;
    }

    private String getIds(DynamicObject rule) {
        StringBuilder sb = new StringBuilder();
        Long val = null;
        int len = RULEIDCOLS.length;
        for (int i = 0; i < len; ++i) {
            val = rule.getLong(RULEIDCOLS[i]);
            if (val == null || val == 0L) {
                sb.append('-');
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    private String getEffectiveString(DynamicObject rowInfo) {
        StringBuilder sb = new StringBuilder();
        DynamicObject val = null;
        int count = 0;
        int len = MDRITEMSALECONTROL.length;
        for (int i = 0; i < len; ++i) {
            val = rowInfo.getDynamicObject(MDRITEMSALECONTROL[i]);
            if (val != null) {
                sb.append(val.get("id"));
                ++count;
                continue;
            }
            sb.append('-');
        }
        if (count != 1) {
            return null;
        }
        return sb.toString();
    }

    private DynamicObject createRuleInfo(DynamicObject rowInfo, DynamicObject saleRule, Map<String, Object> commonInfos) {
        DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)"mdr_salecontrol");
        for (String col : RULECOLS) {
            rule.set(col, rowInfo.get(col));
        }
        DynamicObject owner = saleRule.getDynamicObject("owner");
        DynamicObject customer = saleRule.getDynamicObject("customer");
        DynamicObject customergroup = saleRule.getDynamicObject("customergroup");
        rule.set("owner", owner != null ? owner.get("id") : null);
        rule.set("customer", customer != null ? customer.get("id") : null);
        rule.set("customergroup", customergroup != null ? customergroup.get("id") : null);
        rule.set(ENABLE, (Object)"1");
        rule.set(STATUS, (Object)"A");
        for (Map.Entry<String, Object> info : commonInfos.entrySet()) {
            rule.set(info.getKey(), info.getValue());
        }
        return rule;
    }

    private Map<String, Object> getCommonCreateInfos() {
        HashMap<String, Object> createInfos = new HashMap<String, Object>();
        createInfos.put(CREATE_TIME, new Date());
        createInfos.put(CREATOR, UserUtil.getUserID());
        return createInfos;
    }
}

