/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.spu.validator;

import java.util.Collection;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.validator.BatchFastValidator;

public class SpuSaveValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        HashSet<String> keys = new HashSet<String>();
        StringBuilder key = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : datas) {
            keys.clear();
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entryentity_specmap");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject dy : dynamicObjectCollection) {
                int seq = dy.getInt("seq");
                String nameDy = dy.getString("spumapname");
                if (StringUtils.isEmpty((String)nameDy)) {
                    this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%\u884c,\u89c4\u683c\u7ec4\u5408\u503c\u4e0d\u80fd\u4e3a\u7a7a", seq));
                    continue;
                }
                String numberDy = dy.getString("spumapnumber");
                if (StringUtils.isEmpty((String)numberDy)) {
                    this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%\u884c,\u89c4\u683c\u7ec4\u5408\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", seq));
                    continue;
                }
                DynamicObject itemDy = dy.getDynamicObject("itemid");
                DynamicObject materielDy = dy.getDynamicObject("materielid");
                DynamicObject auxptyDy = dy.getDynamicObject("auxptyid");
                if (itemDy == null) {
                    this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%s\u884c,\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", seq));
                    continue;
                }
                if (materielDy != null && materielDy.getBoolean("isuseauxpty") && auxptyDy == null) {
                    this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%s\u884c,\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", seq));
                    continue;
                }
                Long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)auxptyDy);
                Long itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemDy);
                key.append(itemId).append('_').append(auxptyId);
                if (keys.contains(key.toString())) {
                    this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%s\u884c,\u5546\u54c1+\u8f85\u52a9\u5c5e\u6027\u91cd\u590d", seq));
                    continue;
                }
                keys.add(key.toString());
                key.setLength(0);
                QFilter qFilter = new QFilter("entryentity_specmap.itemid", "=", (Object)itemId);
                qFilter.and("entryentity_specmap.auxptyid", "=", (Object)auxptyId);
                boolean exist = QueryServiceHelper.exists((String)"dbd_spu", (QFilter[])qFilter.toArray());
                if (!exist || data.getDataEntityState().getFromDatabase()) continue;
                this.addFatalErrorMessage(extendedDataEntity, String.format("spu\u89c4\u683c\u7ec4\u5408\u5206\u5f55,\u7b2c%s\u884c,\u5546\u54c1+\u8f85\u52a9\u5c5e\u6027\u5df2\u7ecf\u88ab\u5176\u4ed6spu\u89c4\u683c\u7ec4\u5408\u5f15\u7528", seq));
            }
        }
    }
}

