/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.F7Utils;

public class GetDistributionRulesHelper {
    private static final String KEY_ITEMCLASSENTITY = "itemclassentity";
    private static final String TYPE_ZERO = "0";
    private static final String TYPE_ONE = "1";
    private static final String KEY_PARENT = "parent";

    private static DynamicObject[] getRules() {
        DynamicObject[] rules;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"dbd_distributionrules");
        IAppCache cache = AppCache.get((String)"dbd");
        String rulesCache = (String)cache.get("dbd_distributionrules", String.class);
        if (StringUtils.isNotBlank((CharSequence)rulesCache)) {
            Object[] data = DynamicObjectSerializeUtil.deserialize((String)rulesCache, (DynamicObjectType)type);
            ArrayList lstRules = new ArrayList(data.length);
            Arrays.stream(data).forEach(x -> lstRules.add((DynamicObject)x));
            rules = lstRules.toArray(new DynamicObject[0]);
        } else {
            QFilter filter = F7Utils.getEnableStatus();
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            rules = BusinessDataServiceHelper.load((String)"dbd_distributionrules", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        }
        return rules;
    }

    private static List<DynamicObject> getRulesByBranch(DynamicObject[] rules, long branchId) {
        return Arrays.stream(rules).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"salebranch") == branchId).collect(Collectors.toList());
    }

    private static List<DynamicObject> getRulesByOrg(DynamicObject[] rules, long orgId) {
        return Arrays.stream(rules).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"saleorg") == orgId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"salebranch") == 0L).collect(Collectors.toList());
    }

    private static List<DynamicObject> getRulesByGoods(List<DynamicObject> lstRule, DynamicObject goods, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)TYPE_ZERO)) {
            return lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goods") == DynamicObjectUtils.getPkValue((DynamicObject)goods)).collect(Collectors.toList());
        }
        List<Long> lstItemClassId = GetDistributionRulesHelper.getItemClassIds(goods);
        return lstRule.stream().filter(x -> lstItemClassId.contains(DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"itemclass"))).collect(Collectors.toList());
    }

    private static List<DynamicObject> getRulesByArea(List<DynamicObject> lstRule, long countryId, DynamicObject adminDivision) {
        List<DynamicObject> lstNewRule = new ArrayList<DynamicObject>();
        int areaLevel = DynamicObjectUtils.getInt((DynamicObject)adminDivision, (String)"level");
        switch (areaLevel) {
            case 3: {
                lstNewRule = GetDistributionRulesHelper.getRulesByCounty(lstRule, countryId, adminDivision);
                break;
            }
            case 2: {
                lstNewRule = GetDistributionRulesHelper.getRulesByCity(lstRule, countryId, adminDivision);
                break;
            }
            case 1: {
                lstNewRule = GetDistributionRulesHelper.getRulesByProvince(lstRule, countryId, adminDivision);
                break;
            }
            case 0: {
                lstNewRule = GetDistributionRulesHelper.getRulesByCountry(lstRule, countryId, TYPE_ZERO);
                break;
            }
        }
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByCounty(List<DynamicObject> lstRule, long countryId, DynamicObject adminDivision) {
        long adminDivisionId = DynamicObjectUtils.getPkValue((DynamicObject)adminDivision);
        List<DynamicObject> lstNewRule = lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"county") == adminDivisionId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        long cityId = DynamicObjectUtils.getPkValue((DynamicObject)adminDivision, (String)KEY_PARENT);
        lstNewRule = GetDistributionRulesHelper.getRulesByCity(lstRule, cityId, TYPE_ONE);
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        DynamicObject city = BusinessDataServiceHelper.loadSingleFromCache((Object)cityId, (String)"bd_admindivision");
        long provinceId = DynamicObjectUtils.getPkValue((DynamicObject)city, (String)KEY_PARENT);
        lstNewRule = GetDistributionRulesHelper.getRulesByProvince(lstRule, provinceId, TYPE_ONE);
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        lstNewRule = GetDistributionRulesHelper.getRulesByCountry(lstRule, countryId, TYPE_ONE);
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByCity(List<DynamicObject> lstRule, long countryId, DynamicObject adminDivision) {
        long adminDivisionId = DynamicObjectUtils.getPkValue((DynamicObject)adminDivision);
        List<DynamicObject> lstNewRule = GetDistributionRulesHelper.getRulesByCity(lstRule, adminDivisionId, TYPE_ZERO);
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        long provinceId = DynamicObjectUtils.getPkValue((DynamicObject)adminDivision, (String)KEY_PARENT);
        lstNewRule = GetDistributionRulesHelper.getRulesByProvince(lstRule, provinceId, TYPE_ONE);
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        lstNewRule = GetDistributionRulesHelper.getRulesByCountry(lstRule, countryId, TYPE_ONE);
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByProvince(List<DynamicObject> lstRule, long countryId, DynamicObject adminDivision) {
        long adminDivisionId = DynamicObjectUtils.getPkValue((DynamicObject)adminDivision);
        List<DynamicObject> lstNewRule = GetDistributionRulesHelper.getRulesByProvince(lstRule, adminDivisionId, TYPE_ZERO);
        if (!CollectionUtils.isEmpty(lstNewRule)) {
            return lstNewRule;
        }
        lstNewRule = GetDistributionRulesHelper.getRulesByCountry(lstRule, countryId, TYPE_ONE);
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByCity(List<DynamicObject> lstRule, long cityId, String type) {
        List<Object> lstNewRule = lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"city") == cityId).collect(Collectors.toList());
        if (StringUtils.equals((CharSequence)type, (CharSequence)TYPE_ONE)) {
            lstNewRule = lstNewRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"county") == 0L).collect(Collectors.toList());
        }
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByProvince(List<DynamicObject> lstRule, long provinceId, String type) {
        List<Object> lstNewRule = lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"province") == provinceId).collect(Collectors.toList());
        if (StringUtils.equals((CharSequence)type, (CharSequence)TYPE_ONE)) {
            lstNewRule = lstNewRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"city") == 0L && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"county") == 0L).collect(Collectors.toList());
        }
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByCountry(List<DynamicObject> lstRule, long countryId, String type) {
        List<Object> lstNewRule = lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"country") == countryId).collect(Collectors.toList());
        if (StringUtils.equals((CharSequence)type, (CharSequence)TYPE_ONE)) {
            lstNewRule = lstNewRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"province") == 0L && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"city") == 0L && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"county") == 0L).collect(Collectors.toList());
        }
        return lstNewRule;
    }

    private static List<DynamicObject> getRulesByMode(List<DynamicObject> lstRule, long modeId) {
        return lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"mode") == modeId).collect(Collectors.toList());
    }

    private static List<DynamicObject> getRulesByInventoryOrg(List<DynamicObject> lstRule, long inventoryOrgId) {
        return lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"inventoryorg") == inventoryOrgId).collect(Collectors.toList());
    }

    private static DynamicObject getRule(List<DynamicObject> lstRule) {
        if (lstRule != null && lstRule.size() > 0) {
            lstRule.sort(Comparator.comparingInt(x -> DynamicObjectUtils.getInt((DynamicObject)((DynamicObject)x), (String)"priority")).reversed().thenComparing(y -> DynamicObjectUtils.getDate((DynamicObject)((DynamicObject)y), (String)"modifytime")));
            return lstRule.get(lstRule.size() - 1);
        }
        return null;
    }

    private static List<Long> getItemClassIds(DynamicObject goods) {
        DynamicObjectCollection itemClass = goods.getDynamicObjectCollection(KEY_ITEMCLASSENTITY);
        ArrayList<Long> lstItemClassId = new ArrayList<Long>(itemClass.size());
        if (!CollectionUtils.isEmpty((Collection)itemClass)) {
            itemClass.forEach(x -> lstItemClassId.add(DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsclasssid")));
        }
        return lstItemClassId;
    }

    public static DynamicObject getRule(long branchId, long orgId, DynamicObject goods, long countryId, long adminDivisionId) {
        DynamicObject[] rules = GetDistributionRulesHelper.getRules();
        List<DynamicObject> lstRuleByBranch = GetDistributionRulesHelper.getRulesByBranch(rules, branchId);
        List<DynamicObject> lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ZERO, 0L);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ONE, 0L);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, null, countryId, adminDivisionId, null, 0L);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        List<DynamicObject> lstRuleByOrg = GetDistributionRulesHelper.getRulesByOrg(rules, orgId);
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ZERO, 0L);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ONE, 0L);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, null, countryId, adminDivisionId, null, 0L);
        return GetDistributionRulesHelper.getRule(lstRule);
    }

    public static DynamicObject getRuleByMode(long branchId, long orgId, DynamicObject goods, long countryId, long adminDivisionId, long modeId) {
        DynamicObject[] rules = GetDistributionRulesHelper.getRules();
        List<DynamicObject> lstRuleByBranch = GetDistributionRulesHelper.getRulesByBranch(rules, branchId);
        List<DynamicObject> lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ZERO, modeId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ONE, modeId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByBranch, null, countryId, adminDivisionId, null, modeId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        List<DynamicObject> lstRuleByOrg = GetDistributionRulesHelper.getRulesByOrg(rules, orgId);
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ZERO, modeId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ONE, modeId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRule = GetDistributionRulesHelper.getRules(lstRuleByOrg, null, countryId, adminDivisionId, null, modeId);
        return GetDistributionRulesHelper.getRule(lstRule);
    }

    public static DynamicObject getRuleByInventoryOrg(long branchId, long orgId, DynamicObject goods, long countryId, long adminDivisionId, long modeId, long inventoryOrgId) {
        DynamicObject[] rules = GetDistributionRulesHelper.getRules();
        List<DynamicObject> lstRuleByBranch = GetDistributionRulesHelper.getRulesByBranch(rules, branchId);
        List<DynamicObject> lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ZERO, modeId);
        List<DynamicObject> lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByBranch, goods, countryId, adminDivisionId, TYPE_ONE, modeId);
        lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByBranch, null, countryId, adminDivisionId, null, modeId);
        lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        List<DynamicObject> lstRuleByOrg = GetDistributionRulesHelper.getRulesByOrg(rules, orgId);
        lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ZERO, modeId);
        lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByOrg, goods, countryId, adminDivisionId, TYPE_ONE, modeId);
        lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        if (!CollectionUtils.isEmpty(lstRule)) {
            return GetDistributionRulesHelper.getRule(lstRule);
        }
        lstRuleByMode = GetDistributionRulesHelper.getRules(lstRuleByOrg, null, countryId, adminDivisionId, null, modeId);
        lstRule = GetDistributionRulesHelper.getRulesByInventoryOrg(lstRuleByMode, inventoryOrgId);
        return GetDistributionRulesHelper.getRule(lstRule);
    }

    private static List<DynamicObject> getRules(List<DynamicObject> lstRule, DynamicObject goods, long countryId, long adminDivisionId, String type, long modeId) {
        List<DynamicObject> lstRuleByArea;
        DynamicObject adminDivision = GetDistributionRulesHelper.getAdminDivision(adminDivisionId);
        if (goods != null && type != null) {
            List<DynamicObject> lstRuleByGoods = GetDistributionRulesHelper.getRulesByGoods(lstRule, goods, type);
            lstRuleByArea = GetDistributionRulesHelper.getRulesByArea(lstRuleByGoods, countryId, adminDivision);
        } else {
            List<DynamicObject> lstRuleNoGoods = lstRule.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"itemclass") == 0L && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goods") == 0L).collect(Collectors.toList());
            lstRuleByArea = GetDistributionRulesHelper.getRulesByArea(lstRuleNoGoods, countryId, adminDivision);
        }
        if (modeId > 0L) {
            return GetDistributionRulesHelper.getRulesByMode(lstRuleByArea, modeId);
        }
        return lstRuleByArea;
    }

    private static DynamicObject getAdminDivision(long adminDivisionId) {
        DynamicObject adminDivision = null;
        if (adminDivisionId != 0L) {
            adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivisionId, (String)"bd_admindivision");
        }
        return adminDivision;
    }
}

