/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SetBranchRangeHelper {
    private static final String KEY_BIZGROUPID = "bizgroup.Id";
    private static final String KEY_BRANCH = "mdr_customer";

    public static void setBranchRange(IDataModel model, DynamicObjectCollection data, boolean type, String treeEntryKey, String orgKey, String branchKey) {
        model.deleteEntryData(treeEntryKey);
        model.beginInit();
        if (data == null || data.size() <= 0) {
            return;
        }
        Map<Long, List<DynamicObject>> map = SetBranchRangeHelper.getBranchData(data, type);
        if (map == null || map.size() <= 0) {
            return;
        }
        DynamicObjectCollection treeEntry = model.getEntryEntity(treeEntryKey);
        treeEntry.clear();
        DynamicObjectType treeType = treeEntry.getDynamicObjectType();
        for (Map.Entry<Long, List<DynamicObject>> item : map.entrySet()) {
            long key = item.getKey();
            List<DynamicObject> values = item.getValue();
            int row = 0;
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    DynamicObject org = (DynamicObject)values.get(i).get("bizgroup");
                    Object branchId = values.get(i).get("Id");
                    DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)KEY_BRANCH);
                    DynamicObject treePItem = new DynamicObject(treeType);
                    treePItem.set(orgKey, (Object)org);
                    treePItem.set(branchKey, (Object)branch);
                    row = model.createNewEntryRow(treeEntryKey, treePItem);
                    continue;
                }
                int rowIndex = model.insertEntryRow(treeEntryKey, row);
                model.setValue(branchKey, values.get(i).get("Id"), rowIndex);
            }
        }
        model.endInit();
    }

    private static List<Long> getBaseDataIds(DynamicObjectCollection data) {
        ArrayList<Long> lstBaseDataId = new ArrayList<Long>();
        for (DynamicObject item : data) {
            DynamicObject baseData = item.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            lstBaseDataId.add(baseData.getLong("Id"));
        }
        return lstBaseDataId;
    }

    private static QFilter getCommonFilter() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("isstore", "=", (Object)Boolean.TRUE);
        return filter;
    }

    private static Map<Long, List<DynamicObject>> getBranchData(DynamicObjectCollection data, boolean type) {
        List<Long> lstBaseDataId = SetBranchRangeHelper.getBaseDataIds(data);
        QFilter filter = SetBranchRangeHelper.getCommonFilter();
        if (type) {
            filter.and(KEY_BIZGROUPID, "in", lstBaseDataId);
        } else {
            filter.and("custclassentity.customergroupid.Id", "in", lstBaseDataId);
        }
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(KEY_BRANCH, "id, bizgroup, bizgroup.Id", filter.toArray());
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.stream().collect(Collectors.groupingBy(p -> p.getLong(KEY_BIZGROUPID)));
    }

    public static void setBranchRange(IDataModel model, String treeEntryKey, String orgKey, String branchKey) {
        model.deleteEntryData(treeEntryKey);
        model.beginInit();
        Map<Long, List<DynamicObject>> map = SetBranchRangeHelper.getBranchData();
        if (map == null || map.size() <= 0) {
            return;
        }
        DynamicObjectCollection treeEntry = model.getEntryEntity(treeEntryKey);
        treeEntry.clear();
        DynamicObjectType treeType = treeEntry.getDynamicObjectType();
        for (Map.Entry<Long, List<DynamicObject>> item : map.entrySet()) {
            long key = item.getKey();
            List<DynamicObject> values = item.getValue();
            int row = 0;
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    DynamicObject org = (DynamicObject)values.get(i).get("bizgroup");
                    Object branchId = values.get(i).get("Id");
                    DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)KEY_BRANCH);
                    DynamicObject treePItem = new DynamicObject(treeType);
                    treePItem.set(orgKey, (Object)org);
                    treePItem.set(branchKey, (Object)branch);
                    row = model.createNewEntryRow(treeEntryKey, treePItem);
                    continue;
                }
                int rowIndex = model.insertEntryRow(treeEntryKey, row);
                model.setValue(branchKey, values.get(i).get("Id"), rowIndex);
            }
        }
        model.endInit();
    }

    private static Map<Long, List<DynamicObject>> getBranchData() {
        QFilter filter = SetBranchRangeHelper.getCommonFilter();
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(KEY_BRANCH, "id, bizgroup, bizgroup.Id", filter.toArray());
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.stream().collect(Collectors.groupingBy(p -> p.getLong(KEY_BIZGROUPID)));
    }
}

