/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.handle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;

public class UnitHandler {
    public JSONObject queryUnitInfoByItemIds(List<Object> itemIds) {
        if (itemIds == null || itemIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u975e\u6cd5\uff1aitemIds\u4e0d\u80fd\u4e3anull\u6216\u7a7a\u96c6\u5408", (String)"UnitHandler_0", (String)"drp-dbd-business", (Object[])new Object[0]));
        }
        final String baseUnitKey = "material.baseunit";
        final String baseUnitPrecisionKey = "material.baseunit.precision";
        final String baseUnitPrecisionaccountKey = "material.baseunit.precisionaccount";
        String[] cols = new String[]{"material", "saleunit", "assistunit", "number", baseUnitKey, baseUnitPrecisionKey, baseUnitPrecisionaccountKey, "id"};
        QFilter fs = new QFilter("id", "in", itemIds);
        int size = itemIds.size();
        final ArrayList<Object> materialIds = new ArrayList<Object>(size);
        final JSONObject itemUnitDatas = new JSONObject(size);
        QueryUtil.queryDataSet((Consumer)new Consumer<Row>(){

            @Override
            public void accept(Row t) {
                JSONObject unitData = new JSONObject();
                unitData.put("material", (Object)t.getLong("material").toString());
                unitData.put("number", (Object)t.getString("number"));
                unitData.put("saleUnit", (Object)t.getLong("saleunit"));
                unitData.put("assistUnit", (Object)t.getLong("assistunit"));
                unitData.put("baseUnit", (Object)this.createBaseUnitInfo(t));
                itemUnitDatas.put(t.getLong("id").toString(), (Object)unitData);
                materialIds.add(t.getLong("material"));
            }

            private JSONObject createBaseUnitInfo(Row t) {
                JSONObject baseUnit = new JSONObject();
                baseUnit.put("id", (Object)t.getLong(baseUnitKey));
                baseUnit.put("precision", (Object)t.getInteger(baseUnitPrecisionKey));
                baseUnit.put("precisionaccount", (Object)t.getString(baseUnitPrecisionaccountKey));
                return baseUnit;
            }
        }, (String)ResManager.loadKDString((String)"\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5931\u8d25\uff1a", (String)"UnitHandler_1", (String)"drp-dbd-business", (Object[])new Object[0]), (String)"mdr_item_info", (String)F7Utils.getSelectCols((String[])cols), (QFilter[])fs.toArray(), null);
        if (materialIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u5173\u8054\u7269\u6599", (String)"UnitHandler_2", (String)"drp-dbd-business", (Object[])new Object[0]));
        }
        JSONObject materialUnitListDatas = this.getMaterialUnitListDatas(materialIds);
        this.checkAndAddUnitToItemMap(itemUnitDatas, materialUnitListDatas);
        return itemUnitDatas;
    }

    private void checkAndAddUnitToItemMap(JSONObject itemUnitDatas, JSONObject materialUnitListDatas) {
        String materialId = null;
        JSONObject materialUnitListData = null;
        JSONObject itemUnitData = null;
        for (String itemIdStr : itemUnitDatas.keySet()) {
            itemUnitData = itemUnitDatas.getJSONObject(itemIdStr);
            materialId = itemUnitData.getString("material");
            materialUnitListData = materialUnitListDatas.getJSONObject(materialId);
            if (materialUnitListData == null) {
                materialUnitListData = this.getEmptyUnitListData();
            }
            itemUnitData.putAll((Map)materialUnitListData);
            this.addBaseUnitToUnitList(itemUnitData);
            this.checkUnitIsLegal(itemUnitData);
        }
    }

    private void checkUnitIsLegal(JSONObject itemUnitData) {
        Object number = itemUnitData.remove((Object)"number");
        JSONArray unitIds = itemUnitData.getJSONArray("id");
        int tempIndex = unitIds.indexOf((Object)itemUnitData.getLong("saleUnit"));
        if (tempIndex < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\uff1a\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u7269\u6599\u591a\u8ba1\u91cf\u5355\u4f4d\u8868\u4e2d\uff0c\u8bf7\u6838\u67e5", (String)"UnitHandler_3", (String)"drp-dbd-business", (Object[])new Object[0]), number));
        }
        itemUnitData.put("saleUnit", (Object)tempIndex);
        Long assistUnitId = itemUnitData.getLong("assistUnit");
        if (assistUnitId != null && assistUnitId != 0L) {
            tempIndex = unitIds.indexOf((Object)itemUnitData.getLong("assistUnit"));
            if (tempIndex < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\uff1a\u8f85\u52a9\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u7269\u6599\u591a\u8ba1\u91cf\u5355\u4f4d\u8868\u4e2d\uff0c\u8bf7\u6838\u67e5", (String)"UnitHandler_4", (String)"drp-dbd-business", (Object[])new Object[0]), number));
            }
            itemUnitData.put("assistUnit", (Object)tempIndex);
        } else {
            itemUnitData.put("assistUnit", (Object)-1);
        }
        itemUnitData.remove((Object)"material");
    }

    private void addBaseUnitToUnitList(JSONObject unitInfo) {
        JSONObject baseUnit = unitInfo.getJSONObject("baseUnit");
        int index = unitInfo.getJSONArray("id").size();
        unitInfo.getJSONArray("id").add(baseUnit.get((Object)"id"));
        unitInfo.getJSONArray("precision").add(baseUnit.get((Object)"precision"));
        unitInfo.getJSONArray("precisionaccount").add(baseUnit.get((Object)"precisionaccount"));
        unitInfo.getJSONArray("numerator").add((Object)BigDecimal.ONE);
        unitInfo.getJSONArray("denominator").add((Object)BigDecimal.ONE);
        unitInfo.put("baseUnit", (Object)index);
    }

    public JSONObject queryUnitDataByItemId(Object itemId) {
        if (itemId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u975e\u6cd5\uff1a\u5546\u54c1ID\u4e0d\u80fd\u4e3anull", (String)"UnitHandler_5", (String)"drp-dbd-business", (Object[])new Object[0]));
        }
        ArrayList<Object> ids = new ArrayList<Object>(1);
        ids.add(itemId);
        JSONObject unitInfos = this.queryUnitInfoByItemIds(ids);
        JSONObject unitInfo = unitInfos.getJSONObject(itemId.toString());
        if (unitInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u5546\u54c1\u8bb0\u5f55\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u6838\u67e5\u5546\u54c1\u662f\u5426\u5173\u8054\u7269\u6599\uff0c\u7269\u6599\u662f\u5426\u6709\u591a\u8ba1\u91cf\u5355\u4f4d\u8868", (String)"UnitHandler_6", (String)"drp-dbd-business", (Object[])new Object[0]));
        }
        return unitInfo;
    }

    public JSONObject getUnitDataByMaterialIds(List<Object> materialIds) {
        final String baseUnitKey = "baseunit.id";
        final String number = "number";
        final String basePrecisionKey = "baseunit.precision";
        final String basePrecisionaccount = "baseunit.precisionaccount";
        String[] cols = new String[]{number, baseUnitKey, basePrecisionKey, basePrecisionaccount, "id"};
        QFilter fs = new QFilter("id", "in", materialIds);
        final JSONObject materialUnitDatas = new JSONObject(materialIds.size());
        QueryUtil.queryDataSet((Consumer)new Consumer<Row>(){

            @Override
            public void accept(Row t) {
                materialUnitDatas.put(t.getLong("id").toString(), (Object)this.createBaseInfo(t));
            }

            private JSONObject createBaseInfo(Row t) {
                JSONObject unitData = new JSONObject();
                JSONObject baseUnitData = new JSONObject();
                baseUnitData.put("id", (Object)t.getLong(baseUnitKey));
                baseUnitData.put("precision", (Object)t.getInteger(basePrecisionKey));
                baseUnitData.put("precisionaccount", (Object)t.getString(basePrecisionaccount));
                baseUnitData.put(number, (Object)t.getString(number));
                unitData.put("baseUnit", (Object)baseUnitData);
                return unitData;
            }
        }, (String)ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5931\u8d25\uff1a", (String)"UnitHandler_7", (String)"drp-dbd-business", (Object[])new Object[0]), (String)"bd_material", (String)F7Utils.getSelectCols((String[])cols), (QFilter[])fs.toArray(), null);
        JSONObject materialUnitListDatas = this.getMaterialUnitListDatas(materialIds);
        this.handleMaterialUnits(materialUnitDatas, materialUnitListDatas);
        return materialUnitDatas;
    }

    private void handleMaterialUnits(JSONObject materialUnitDatas, JSONObject materialUnitListDatas) {
        JSONObject materialUnitData = null;
        JSONObject materialUnitListData = null;
        for (String materialId : materialUnitDatas.keySet()) {
            materialUnitData = materialUnitDatas.getJSONObject(materialId);
            materialUnitListData = materialUnitListDatas.getJSONObject(materialId);
            if (materialUnitListData == null) {
                materialUnitListData = this.getEmptyUnitListData();
            }
            materialUnitData.putAll((Map)materialUnitListData);
            this.addBaseUnitToUnitList(materialUnitData);
        }
    }

    private JSONObject getEmptyUnitListData() {
        JSONObject unitListData = new JSONObject(5);
        unitListData.put("id", (Object)new JSONArray());
        unitListData.put("denominator", (Object)new JSONArray());
        unitListData.put("numerator", (Object)new JSONArray());
        unitListData.put("precision", (Object)new JSONArray());
        unitListData.put("precisionaccount", (Object)new JSONArray());
        return unitListData;
    }

    private JSONObject getMaterialUnitListDatas(List<Object> materialIds) {
        final String precisionKey = "measureunitid.precision";
        final String precisionaccount = "measureunitid.precisionaccount";
        String[] cols = new String[]{"measureunitid", "denominator", "numerator", precisionKey, precisionaccount, "materialid"};
        final JSONObject materialUnitListDatas = new JSONObject(materialIds.size());
        QFilter fs = new QFilter("materialid", "in", materialIds);
        QueryUtil.queryDataSet((Consumer)new Consumer<Row>(){

            @Override
            public void accept(Row t) {
                String materialIdStr = t.get("materialid").toString();
                JSONObject materialUnitListData = materialUnitListDatas.getJSONObject(materialIdStr);
                if (materialUnitListData == null) {
                    materialUnitListData = UnitHandler.this.getEmptyUnitListData();
                    materialUnitListDatas.put(materialIdStr, (Object)materialUnitListData);
                }
                materialUnitListData.getJSONArray("id").add((Object)t.getLong("measureunitid"));
                materialUnitListData.getJSONArray("denominator").add((Object)t.getBigDecimal("denominator"));
                materialUnitListData.getJSONArray("numerator").add((Object)t.getBigDecimal("numerator"));
                materialUnitListData.getJSONArray("precision").add((Object)t.getInteger(precisionKey));
                materialUnitListData.getJSONArray("precisionaccount").add((Object)t.getString(precisionaccount));
            }
        }, (String)ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5931\u8d25\uff1a", (String)"UnitHandler_7", (String)"drp-dbd-business", (Object[])new Object[0]), (String)"bd_multimeasureunit", (String)F7Utils.getSelectCols((String[])cols), (QFilter[])fs.toArray(), null);
        return materialUnitListDatas;
    }
}

