/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.botp.ConvertDataService;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class BotpHelper {
    public static boolean isSourcePushTarget(String sourceEntityNumber, String sourceEntryKey, String targetEntityNumber, String targetEntryKey, Long[] sourceEntryIds) {
        List loadRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)sourceEntityNumber, (String)sourceEntryKey, (Long[])sourceEntryIds);
        if (!CollectionUtils.isEmpty((Collection)loadRowIds)) {
            Long targetEntryTableId = new ConvertDataService().loadTableDefine(targetEntityNumber, targetEntryKey).getTableId();
            for (Long sourceEntryId : sourceEntryIds) {
                Long targetEntryId = BotpHelper.getTargetEntryId(loadRowIds, targetEntryTableId, sourceEntryId, new ArrayList<Long>());
                if (targetEntryId <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Long, Long> getSourceEntryPushTargetEntryMap(String sourceEntityNumber, String sourceEntryKey, String targetEntityNumber, String targetEntryKey, Long[] sourceEntryIds) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(sourceEntryIds == null ? 0 : sourceEntryIds.length);
        List loadRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)sourceEntityNumber, (String)sourceEntryKey, (Long[])sourceEntryIds);
        if (!CollectionUtils.isEmpty((Collection)loadRowIds)) {
            Long targetEntryTableId = new ConvertDataService().loadTableDefine(targetEntityNumber, targetEntityNumber).getTableId();
            for (Long sourceEntryId : sourceEntryIds) {
                Long targetEntryId = BotpHelper.getTargetEntryId(loadRowIds, targetEntryTableId, sourceEntryId, new ArrayList<Long>());
                resultMap.put(sourceEntryId, targetEntryId);
            }
        }
        return resultMap;
    }

    private static Long getTargetEntryId(List<BFRow> loadRowIds, Long targetTableId, Long sourceEntryId, List<Long> bfTargetEntryIds) {
        if (CollectionUtils.isEmpty(loadRowIds)) {
            return 0L;
        }
        Iterator<BFRow> iterator = loadRowIds.iterator();
        while (iterator.hasNext()) {
            BFRow bfRow = iterator.next();
            Long bfSourceEntryId = bfRow.getSId().getEntryId();
            Long bfTagertEntryId = bfRow.getId().getEntryId();
            if (bfTargetEntryIds.contains(bfTagertEntryId) || bfSourceEntryId == null || !sourceEntryId.equals(bfSourceEntryId)) continue;
            iterator.remove();
            if (targetTableId.equals(bfRow.getId().getTableId())) {
                return bfTagertEntryId;
            }
            bfTargetEntryIds.add(bfTagertEntryId);
            return BotpHelper.getTargetEntryId(loadRowIds, targetTableId, bfTagertEntryId, bfTargetEntryIds);
        }
        return 0L;
    }

    public static boolean isSourceFromTarget(String sourceEntityNumber, String sourceEntryKey, String targetEntityNumber, String targetEntryKey, Long[] sourceEntryIds) {
        List loadSourceRowIds = BFTrackerServiceHelper.loadSourceRowIds((String)sourceEntityNumber, (String)sourceEntryKey, (Long[])sourceEntryIds);
        if (!CollectionUtils.isEmpty((Collection)loadSourceRowIds)) {
            Long targetEntryTableId = new ConvertDataService().loadTableDefine(targetEntityNumber, targetEntryKey).getTableId();
            for (Long sourceEntryId : sourceEntryIds) {
                Long targetEntryId = BotpHelper.getSourceEntryId(loadSourceRowIds, targetEntryTableId, sourceEntryId, new ArrayList<Long>());
                if (targetEntryId <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Long, Long> getSourceEntryFromTargetEntryMap(String sourceEntityNumber, String sourceEntryKey, String targetEntityNumber, String targetEntryKey, Long[] sourceEntryIds) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(sourceEntryIds == null ? 0 : sourceEntryIds.length);
        List loadSourceRowIds = BFTrackerServiceHelper.loadSourceRowIds((String)sourceEntityNumber, (String)sourceEntryKey, (Long[])sourceEntryIds);
        if (!CollectionUtils.isEmpty((Collection)loadSourceRowIds)) {
            Long targetEntryTableId = new ConvertDataService().loadTableDefine(targetEntityNumber, targetEntryKey).getTableId();
            for (Long sourceEntryId : sourceEntryIds) {
                Long targetEntryId = BotpHelper.getSourceEntryId(loadSourceRowIds, targetEntryTableId, sourceEntryId, new ArrayList<Long>());
                resultMap.put(sourceEntryId, targetEntryId);
            }
        }
        return resultMap;
    }

    private static Long getSourceEntryId(List<BFRow> loadSourceRowIds, Long sourceTableId, Long targetEntryId, List<Long> bfSourceEntryIds) {
        if (CollectionUtils.isEmpty(loadSourceRowIds)) {
            return 0L;
        }
        Iterator<BFRow> iterator = loadSourceRowIds.iterator();
        while (iterator.hasNext()) {
            BFRow bfRow = iterator.next();
            Long bfSourceEntryId = bfRow.getSId().getEntryId();
            Long bfTagertEntryId = bfRow.getId().getEntryId();
            if (bfSourceEntryIds.contains(bfSourceEntryId) || bfTagertEntryId == null || !targetEntryId.equals(bfTagertEntryId)) continue;
            iterator.remove();
            if (sourceTableId.equals(bfRow.getSId().getTableId())) {
                return bfSourceEntryId;
            }
            bfSourceEntryIds.add(bfSourceEntryId);
            return BotpHelper.getSourceEntryId(loadSourceRowIds, sourceTableId, bfSourceEntryId, bfSourceEntryIds);
        }
        return 0L;
    }
}

