/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.F7Utils;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.enums.Enable;

public class ItemSaleContentHelper {
    public static final String EF_goodsid = "goodsid";
    public static final String KEY_BARCODE = "barcode";

    public static List<Map<String, Long>> getItemSaleContent(long branchId, long currencyId) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("customer", "=", (Object)branchId);
        filter.and("retailprice", "!=", (Object)BigDecimal.ZERO);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("enable", "=", (Object)"1");
        filter.and("item.status", "=", (Object)"C");
        filter.and("item.enable", "=", (Object)"1");
        filter.and("barcode.status", "=", (Object)"C");
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"item", KEY_BARCODE});
        DynamicObjectCollection data = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)selectFields, (QFilter[])filter.toArray());
        if (data == null || data.isEmpty()) {
            return new ArrayList<Map<String, Long>>();
        }
        ArrayList<Map<String, Long>> result = new ArrayList<Map<String, Long>>();
        for (DynamicObject item : data) {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put(EF_goodsid, DynamicObjectUtils.getLong((DynamicObject)item, (String)"item"));
            map.put(KEY_BARCODE, DynamicObjectUtils.getLong((DynamicObject)item, (String)KEY_BARCODE));
            result.add(map);
        }
        return result;
    }

    public static QFilter getBarcodeFilter(long branchId, long currencyId, QFilter addFilter) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("customer", "=", (Object)branchId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("barcode.status", "=", (Object)"C");
        filter.and("enable", "=", (Object)Enable.ENABLE);
        if (addFilter != null) {
            filter.and(addFilter);
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)KEY_BARCODE, (QFilter[])filter.toArray());
        QFilter qFilter = null;
        Set<Object> barcodeIds = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            barcodeIds = data.stream().map(m -> m.get(KEY_BARCODE)).collect(Collectors.toSet());
        }
        qFilter = new QFilter("id", "in", barcodeIds);
        return qFilter;
    }
}

