/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;

public class MarketActivityHelper {
    private static final String KEY_BIZGROUPID = "bizgroup.Id";
    private static final String KEY_BRANCH = "mdr_customer";

    public static void setBranchRange(IDataModel dataModel, DynamicObjectCollection multipleBaseData, boolean isOrgRange) {
        dataModel.deleteEntryData("treeentryentity");
        if (multipleBaseData == null || multipleBaseData.size() <= 0) {
            return;
        }
        Map<Long, List<DynamicObject>> map = MarketActivityHelper.queryTreeEntryEntityData(multipleBaseData, isOrgRange);
        if (map == null || map.size() <= 0) {
            return;
        }
        dataModel.beginInit();
        MarketActivityHelper.setTreeEntryEntityData(dataModel, map);
        dataModel.endInit();
    }

    private static void setTreeEntryEntityData(IDataModel dataModel, Map<Long, List<DynamicObject>> map) {
        DynamicObjectCollection treeEntry = dataModel.getEntryEntity("treeentryentity");
        treeEntry.clear();
        DynamicObjectType treeType = treeEntry.getDynamicObjectType();
        for (Map.Entry<Long, List<DynamicObject>> item : map.entrySet()) {
            long key = item.getKey();
            List<DynamicObject> values = item.getValue();
            Long firstRowId = 0L;
            boolean row = false;
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    DynamicObject org = (DynamicObject)values.get(i).get("bizgroup");
                    Long branchId = (Long)values.get(i).get("Id");
                    DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)KEY_BRANCH);
                    DynamicObject treePItem = new DynamicObject(treeType);
                    treePItem.set("orgid", (Object)org);
                    treePItem.set("branchid", (Object)branch);
                    firstRowId = DBServiceHelper.genGlobalLongId();
                    treePItem.set("id", (Object)firstRowId);
                    treeEntry.add(0, treePItem);
                    continue;
                }
                DynamicObject subTreePItem = new DynamicObject(treeType);
                subTreePItem.set("pid", (Object)firstRowId);
                subTreePItem.set("isGroupNode", (Object)Boolean.TRUE);
                subTreePItem.set("branchid_id", values.get(i).get("Id"));
                treeEntry.add(i - 1, subTreePItem);
            }
        }
        dataModel.batchInsertEntryRow(new EntryProp("treeentryentity", treeType), 0, treeEntry);
    }

    private static QFilter getCommonFilter() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("isstore", "=", (Object)Boolean.TRUE);
        return filter;
    }

    private static List<Long> getMultipleBaseDataIds(DynamicObjectCollection multipleBaseData) {
        ArrayList<Long> multipleBaseDataIds = new ArrayList<Long>();
        for (DynamicObject item : multipleBaseData) {
            DynamicObject baseData = item.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            multipleBaseDataIds.add(baseData.getLong("Id"));
        }
        return multipleBaseDataIds;
    }

    private static Map<Long, List<DynamicObject>> queryTreeEntryEntityData(DynamicObjectCollection multipleBaseData, boolean isOrgRange) {
        List<Long> multipleBaseDataIds = MarketActivityHelper.getMultipleBaseDataIds(multipleBaseData);
        QFilter filter = MarketActivityHelper.getCommonFilter();
        if (isOrgRange) {
            filter.and(KEY_BIZGROUPID, "in", multipleBaseDataIds);
        } else {
            filter.and("custclassentity.customergroupid.Id", "in", multipleBaseDataIds);
        }
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(KEY_BRANCH, "id, bizgroup, bizgroup.Id", filter.toArray());
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.stream().collect(Collectors.groupingBy(p -> p.getLong(KEY_BIZGROUPID)));
    }
}

