/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;

public class SetBranchRangeHelper {
    private static final String KEY_BIZGROUPID = "bizgroup.Id";
    private static final String KEY_BRANCH = "mdr_customer";

    public static void setBranchRange(IDataModel model, DynamicObjectCollection data, boolean type, String treeEntryKey, String orgKey, String branchKey, QFilter qFilter) {
        model.deleteEntryData(treeEntryKey);
        model.beginInit();
        if (data == null || data.size() <= 0) {
            return;
        }
        Map<Long, List<DynamicObject>> map = SetBranchRangeHelper.getBranchData(data, type, qFilter);
        if (map == null || map.size() <= 0) {
            return;
        }
        DynamicObjectCollection treeEntry = model.getEntryEntity(treeEntryKey);
        treeEntry.clear();
        DynamicObjectType treeType = treeEntry.getDynamicObjectType();
        for (Map.Entry<Long, List<DynamicObject>> item : map.entrySet()) {
            List<DynamicObject> values = item.getValue();
            DynamicObject org = (DynamicObject)values.get(0).get("bizgroup");
            Object branchId = values.get(0).get("Id");
            DynamicObject branch = BusinessDataServiceHelper.newDynamicObject((String)KEY_BRANCH);
            branch.set("id", branchId);
            branch.set("bizgroup", (Object)org);
            branch.set("name", (Object)values.get(0).getString("name"));
            branch.set("number", (Object)values.get(0).getString("number"));
            DynamicObject treePItem = new DynamicObject(treeType);
            treePItem.set(orgKey, (Object)org);
            treePItem.set(branchKey, (Object)branch);
            Long firstRowId = DBServiceHelper.genGlobalLongId();
            treePItem.set("id", (Object)firstRowId);
            treeEntry.add(0, treePItem);
            for (int i = 1; i < values.size(); ++i) {
                DynamicObject subTreePItem = new DynamicObject(treeType);
                subTreePItem.set("pid", (Object)firstRowId);
                subTreePItem.set("isGroupNode", (Object)Boolean.TRUE);
                subTreePItem.set(branchKey + "_id", values.get(i).get("Id"));
                treeEntry.add(i - 1, subTreePItem);
            }
        }
        model.batchInsertEntryRow(new EntryProp(treeEntryKey, treeType), 0, treeEntry);
        model.endInit();
    }

    private static List<Long> getBaseDataIds(DynamicObjectCollection data) {
        ArrayList<Long> lstBaseDataId = new ArrayList<Long>();
        for (DynamicObject item : data) {
            DynamicObject baseData = item.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            lstBaseDataId.add(baseData.getLong("Id"));
        }
        return lstBaseDataId;
    }

    private static QFilter getCommonFilter() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        return qFilter;
    }

    private static Map<Long, List<DynamicObject>> getBranchData(DynamicObjectCollection data, boolean type, QFilter qFilter) {
        List<Long> lstBaseDataId = SetBranchRangeHelper.getBaseDataIds(data);
        QFilter filter = SetBranchRangeHelper.getCommonFilter();
        if (type) {
            filter.and(KEY_BIZGROUPID, "in", lstBaseDataId);
        } else {
            filter.and("custclassentity.customergroupid.Id", "in", lstBaseDataId);
        }
        if (qFilter != null) {
            filter.and(qFilter);
        } else {
            filter.and("isstore", "=", (Object)Boolean.TRUE);
        }
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(KEY_BRANCH, "id, bizgroup, bizgroup.Id,number,name,bizgroup.name,bizgroup.number", filter.recombine());
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.stream().collect(Collectors.groupingBy(p -> p.getLong(KEY_BIZGROUPID)));
    }
}

