/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.enums.DataStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class TicketActionFlowProcessor {
    private static Log logger = LogFactory.getLog(TicketActionFlowProcessor.class);

    public List<TicketActionFlowVO> saveTicketActionFLow(TicketFlowParamVO ticketFlowParamVO) {
        List<TicketActionFlowVO> ticketActionFlowVOList = this.getTicketActionFlow(ticketFlowParamVO);
        this.batchSaveTicketActionFlow(ticketActionFlowVOList);
        return ticketActionFlowVOList;
    }

    public void batchSaveTicketActionFlow(List<TicketActionFlowVO> ticketActionFlowVOList) {
        if (ticketActionFlowVOList == null || ticketActionFlowVOList.size() < 1) {
            return;
        }
        ArrayList<DynamicObject> tempArrays = new ArrayList<DynamicObject>(ticketActionFlowVOList.size());
        DynamicObject newDynObj = null;
        String userId = RequestContext.get().getUserId();
        Date nowTime = TimeServiceHelper.now();
        for (TicketActionFlowVO ticketFlow : ticketActionFlowVOList) {
            newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"gcm_ticketactionflow");
            newDynObj.set("createtime", (Object)nowTime);
            newDynObj.set("creator", (Object)userId);
            newDynObj.set("billstatus", (Object)DataStatusEnum.AUDITED.toString());
            newDynObj.set("billno", (Object)ticketFlow.getBillNo());
            newDynObj.set("ticketid", (Object)ticketFlow.getTicketID());
            newDynObj.set("tickettypeid", (Object)ticketFlow.getTicketTypeID());
            newDynObj.set("opertype", (Object)ticketFlow.getOperType());
            newDynObj.set("ticketstatus", (Object)ticketFlow.getTicketStatus());
            newDynObj.set("bizdate", (Object)ticketFlow.getBizDate());
            newDynObj.set("billformid", (Object)ticketFlow.getBillFormID());
            newDynObj.set("branchid", (Object)ticketFlow.getBranchID());
            newDynObj.set("orgid", (Object)ticketFlow.getOrgID());
            newDynObj.set("amt", (Object)ticketFlow.getAmt());
            newDynObj.set("operatorid", (Object)ticketFlow.getOperatorID());
            newDynObj.set("auditdate", (Object)ticketFlow.getBizDate());
            newDynObj.set("auditor", (Object)ticketFlow.getOperatorID());
            newDynObj.set("option", (Object)ticketFlow.getOption());
            newDynObj.set("comment", (Object)ticketFlow.getComment());
            tempArrays.add(newDynObj);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])tempArrays.toArray(new DynamicObject[tempArrays.size()]));
        }
        catch (Throwable e) {
            logger.error("\u6e20\u9053\u4e91\u4fdd\u5b58\u793c\u5238\u6d41\u6c34\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    protected abstract List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO var1);

    protected static long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }
}

