/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketIssueFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketMakeColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketMakeColl == null || ticketMakeColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)TicketIssueFlowProcessor.getBaseDataLongPkId(ticketMakeColl[0], "ticketsdistributeid"));
        DynamicObject[] ticketIssueColl = BusinessDataServiceHelper.load((String)"gcm_issuescheme", (String)String.join((CharSequence)",", "auditor", "audittime", "branchid", "totalticketamt", "number", "auditor", "bizorgid", "startdate", "enddate"), (QFilter[])new QFilter[]{qFilter}, (String)"audittime desc");
        if (ticketIssueColl == null || ticketIssueColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> ticketActionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketMakeColl.length);
        DynamicObject ticketIssue = ticketIssueColl[0];
        Date nowTime = TimeServiceHelper.now();
        for (DynamicObject dyn : ticketMakeColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(ticketIssue.getString("number"));
            ticketActionFlowVO.setTicketID(((Long)dyn.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketIssueFlowProcessor.getBaseDataLongPkId(dyn, "tickettypeid"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.SEND.getName());
            ticketActionFlowVO.setBizDate(ticketIssue.getDate("audittime") != null ? ticketIssue.getDate("audittime") : nowTime);
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setBranchID(TicketIssueFlowProcessor.getBaseDataLongPkId(ticketIssue, "branchid"));
            ticketActionFlowVO.setOrgID(TicketIssueFlowProcessor.getBaseDataLongPkId(ticketIssue, "bizorgid"));
            ticketActionFlowVO.setAmt(ticketIssue.getBigDecimal("totalticketamt"));
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue());
            ticketActionFlowVO.setComment(dyn.getString("comment"));
            ticketActionFlowVO.setOperatorID(TicketIssueFlowProcessor.getBaseDataLongPkId(ticketIssue, "auditor"));
            ticketActionFlowVO.setStartTime(ticketIssue.getDate("startdate"));
            ticketActionFlowVO.setEndTime(ticketIssue.getDate("enddate"));
            ticketActionFlowVOS.add(ticketActionFlowVO);
        }
        return ticketActionFlowVOS;
    }
}

