/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketOrderRefundFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketMakeColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketMakeColl == null || ticketMakeColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        QFilter qFilter = new QFilter("salestatus", "=", (Object)"S");
        qFilter.and("id", "=", (Object)ticketFlowParamVO.getSourceBillId());
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((String)"pos_salesorder", (String)String.join((CharSequence)",", "saler", "finentity", "billno", "salebranchid", "bizorgid", "finentity.paytime", "auditdate"), (QFilter[])new QFilter[]{qFilter});
        if (saleOrder == null) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> ticketActionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketMakeColl.length);
        Date bizDate = TimeServiceHelper.now();
        for (DynamicObject temp : ticketMakeColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(saleOrder.getString("billno"));
            ticketActionFlowVO.setTicketID(((Long)temp.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketOrderRefundFlowProcessor.getBaseDataLongPkId(temp, "tickettypeid"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setBranchID(TicketOrderRefundFlowProcessor.getBaseDataLongPkId(saleOrder, "salebranchid"));
            ticketActionFlowVO.setOrgID(TicketOrderRefundFlowProcessor.getBaseDataLongPkId(saleOrder, "bizorgid"));
            ticketActionFlowVO.setBizDate(bizDate);
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.RECOVERY.getName());
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_NEG.getValue());
            ticketActionFlowVO.setOperatorID(TicketOrderRefundFlowProcessor.getBaseDataLongPkId(saleOrder, "saler"));
            ticketActionFlowVOS.add(ticketActionFlowVO);
        }
        return ticketActionFlowVOS;
    }
}

