/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketPublishFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketColl == null || ticketColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)ticketColl[0].getLong("publishbillid"));
        DynamicObject[] ticketIssueColl = BusinessDataServiceHelper.load((String)"gcm_ticketspublish", (String)String.join((CharSequence)",", "realamount", "auditdate"), (QFilter[])new QFilter[]{qFilter}, (String)"auditdate desc");
        if (ticketIssueColl == null || ticketIssueColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> actionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketColl.length);
        for (DynamicObject temp : ticketColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(temp.getString("publishbillno"));
            ticketActionFlowVO.setTicketID(((Long)temp.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketPublishFlowProcessor.getBaseDataLongPkId(temp, "tickettypeid"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.SEND.getName());
            ticketActionFlowVO.setBizDate(temp.getDate("publishtime") != null ? temp.getDate("publishtime") : TimeServiceHelper.now());
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setBranchID(TicketPublishFlowProcessor.getBaseDataLongPkId(temp, "publishbranchid"));
            ticketActionFlowVO.setOrgID(TicketPublishFlowProcessor.getBaseDataLongPkId(temp, "publishorgid"));
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue());
            ticketActionFlowVO.setAmt(ticketIssueColl[0].getBigDecimal("realamount"));
            ticketActionFlowVO.setComment(temp.getString("comment"));
            ticketActionFlowVO.setOperatorID(TicketPublishFlowProcessor.getBaseDataLongPkId(temp, "publisherid"));
            actionFlowVOS.add(ticketActionFlowVO);
        }
        return actionFlowVOS;
    }
}

