/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketReceiveFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    protected List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketColl == null || ticketColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> actionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketColl.length);
        for (DynamicObject temp : ticketColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(temp.getString("receivebillno"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setBranchID(TicketReceiveFlowProcessor.getBaseDataLongPkId(temp, "receivebranchid"));
            ticketActionFlowVO.setOrgID(TicketReceiveFlowProcessor.getBaseDataLongPkId(temp, "receiveorgid"));
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setBizDate(temp.getDate("receivetime"));
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.RECEIVED.getName());
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue());
            ticketActionFlowVO.setTicketID(((Long)temp.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketReceiveFlowProcessor.getBaseDataLongPkId(temp, "tickettypeid"));
            ticketActionFlowVO.setAmt((BigDecimal)temp.get("realsaleamount"));
            ticketActionFlowVO.setComment(temp.getString("comment"));
            ticketActionFlowVO.setOperatorID(TicketReceiveFlowProcessor.getBaseDataLongPkId(temp, "receiverid"));
            actionFlowVOS.add(ticketActionFlowVO);
        }
        return actionFlowVOS;
    }
}

