/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketRecoveryFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketColl == null || ticketColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)ticketColl[0].getLong("recyclebillid"));
        DynamicObject[] ticketRecovery = BusinessDataServiceHelper.load((String)"gcm_ticketsreturn", (String)String.join((CharSequence)",", "billno", "branchid", "org", "id", "auditdate"), (QFilter[])new QFilter[]{qFilter}, (String)"auditdate desc");
        if (ticketRecovery == null || ticketRecovery.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> actionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketColl.length);
        DynamicObject ticket = ticketRecovery[0];
        for (DynamicObject temp : ticketColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(ticket.getString("billno"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.RECOVERY.getName());
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setBizDate(ticket.getDate("auditdate"));
            ticketActionFlowVO.setBranchID(TicketRecoveryFlowProcessor.getBaseDataLongPkId(ticket, "branchid"));
            ticketActionFlowVO.setOrgID(TicketRecoveryFlowProcessor.getBaseDataLongPkId(ticket, "org"));
            ticketActionFlowVO.setTicketID(((Long)temp.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketRecoveryFlowProcessor.getBaseDataLongPkId(temp, "tickettypeid"));
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue());
            ticketActionFlowVO.setAmt((BigDecimal)temp.get("realsaleamount"));
            ticketActionFlowVO.setComment(temp.getString("comment"));
            ticketActionFlowVO.setOperatorID(TicketRecoveryFlowProcessor.getBaseDataLongPkId(temp, "recyclerid"));
            actionFlowVOS.add(ticketActionFlowVO);
        }
        return actionFlowVOS;
    }
}

