/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TicketRuleCodeHelper {
    private static String initial = "0";
    private static String endRandom = "";
    private static String typeSeqCode = "";
    private static int cnt = 0;

    public static List<String> getTicketCode(long ruleId, int cnt) {
        ArrayList<String> lstTickets = new ArrayList<String>(0);
        DynamicObject doCodeRule = TicketRuleCodeHelper.getCodeRule(ruleId);
        if (doCodeRule != null) {
            String init = "0";
            for (int i = 0; i < cnt; ++i) {
                String strRuleCode = TicketRuleCodeHelper.genRuleCode(doCodeRule, init);
                String[] codes = strRuleCode.split(":");
                if (codes.length < 2) continue;
                String ruleCode = codes[0];
                init = String.valueOf(Integer.parseInt(codes[1]));
                if (StringUtils.isEmpty((CharSequence)ruleCode)) continue;
                lstTickets.add(ruleCode);
            }
        }
        return lstTickets;
    }

    public static Map<String, Object> getCodes(long ruleId, int cnt) {
        HashMap<String, Object> ticketCodes = new HashMap<String, Object>(2);
        ArrayList<String> lstTickets = new ArrayList<String>(0);
        DynamicObject doCodeRule = TicketRuleCodeHelper.getCodeRule(ruleId);
        if (doCodeRule != null) {
            String init = "0";
            for (int i = 0; i < cnt; ++i) {
                String strRuleCode = TicketRuleCodeHelper.genRuleCode(doCodeRule, init);
                String[] codes = strRuleCode.split(":");
                if (codes.length < 2) continue;
                String ruleCode = codes[0];
                init = String.valueOf(Integer.parseInt(codes[1]));
                if (StringUtils.isEmpty((CharSequence)ruleCode)) continue;
                lstTickets.add(ruleCode);
            }
            ticketCodes.put("init", init);
            ticketCodes.put("codes", lstTickets);
        }
        return ticketCodes;
    }

    private static String genRuleCode(DynamicObject doCodeRule, String init) {
        Boolean bIsError = Boolean.FALSE;
        String endRandomVal = doCodeRule.getString("endrandom");
        String skipVal = doCodeRule.getString("skip");
        boolean isUpGradeVal = doCodeRule.getBoolean("isupgrade");
        int sequence = doCodeRule.getInt("sequence");
        DynamicObjectCollection codeRuleEntry = doCodeRule.getDynamicObjectCollection("coderuleentry");
        StringBuilder exampleCode = new StringBuilder();
        for (int i = 0; i < codeRuleEntry.getRowCount(); ++i) {
            DynamicObject doEntry = (DynamicObject)codeRuleEntry.get(i);
            if (!doEntry.getBoolean("isenabled")) continue;
            int attributeType = doEntry.getInt("attributetype");
            Object splitSign = doEntry.get("splitsign");
            switch (attributeType) {
                case 1: {
                    String fixVal = String.valueOf(doEntry.get("fixval"));
                    String formatVal = String.valueOf(doEntry.get("format"));
                    fixVal = TicketRuleCodeHelper.getStrFormat(fixVal, formatVal);
                    exampleCode.append(fixVal);
                    if (splitSign == null) break;
                    exampleCode.append(splitSign.toString().trim());
                    break;
                }
                case 2: {
                    String seqCode;
                    int length = Integer.parseInt(String.valueOf(doEntry.get("length")));
                    int step = Integer.parseInt(String.valueOf(doEntry.get("step")));
                    if (sequence != 0 && "0".equals(init)) {
                        init = String.valueOf(sequence);
                    }
                    if (!StringUtils.isEmpty((CharSequence)(seqCode = TicketRuleCodeHelper.getTicketCode(skipVal, step, length, isUpGradeVal, init)))) {
                        init = seqCode;
                        String seqNo = String.format("%0" + length + "d", Integer.parseInt(seqCode));
                        exampleCode.append(seqNo);
                        if (splitSign == null) break;
                        exampleCode.append(splitSign.toString().trim());
                        break;
                    }
                    bIsError = Boolean.TRUE;
                    exampleCode = new StringBuilder();
                    break;
                }
            }
            if (!bIsError.booleanValue()) continue;
            exampleCode = new StringBuilder();
            break;
        }
        int randomLen = endRandomVal != null ? Integer.parseInt(endRandomVal) : 0;
        TicketRuleCodeHelper.getSkipRandom(randomLen, skipVal);
        if (!StringUtils.isBlank((CharSequence)endRandom)) {
            exampleCode.append(endRandom);
        }
        exampleCode.append(':').append(init);
        return exampleCode.toString();
    }

    public static void updateSequence(long ruleId, int cnt) {
        DynamicObject doCodeRule = TicketRuleCodeHelper.getCodeRule(ruleId);
        if (doCodeRule != null) {
            doCodeRule.set("sequence", (Object)cnt);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{doCodeRule});
        }
    }

    private static DynamicObject getCodeRule(long ruleId) {
        return BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"gcm_ticketscoderule");
    }

    public static String getStrFormat(String code, String strFormat) {
        String resultStr;
        switch (strFormat) {
            case "0": {
                resultStr = code;
                break;
            }
            case "1": {
                resultStr = code.toUpperCase();
                break;
            }
            case "2": {
                resultStr = code.toLowerCase();
                break;
            }
            default: {
                resultStr = code;
            }
        }
        return resultStr;
    }

    private static void getSkipRandom(int len, String skip) {
        boolean isSkip = false;
        endRandom = TicketRuleCodeHelper.getRandom(len);
        if (skip == null) {
            return;
        }
        String[] skips = skip.split(",");
        if (skips.length > 1) {
            for (int i = 1; i < skips.length; ++i) {
                if (!endRandom.contains(String.valueOf(skips[i]))) continue;
                endRandom = TicketRuleCodeHelper.getRandom(len);
                isSkip = true;
                ++cnt;
                break;
            }
            if (isSkip && cnt <= 5) {
                TicketRuleCodeHelper.getSkipRandom(len, skip);
            } else {
                cnt = 0;
            }
        }
    }

    private static void getSkipCode(String skip, int step, int len, boolean isUpGrade, String skipVal) {
        typeSeqCode = StringUtils.isBlank((CharSequence)skipVal) ? String.valueOf(Integer.parseInt(initial) + step) : skipVal;
        if (step == 0) {
            ++step;
        }
        boolean isSkip = false;
        if (skip == null) {
            initial = typeSeqCode;
            return;
        }
        String[] skips = skip.split(",");
        if (skips.length > 1) {
            for (int i = 1; i < skips.length; ++i) {
                if (!typeSeqCode.contains(skips[i])) continue;
                initial = typeSeqCode = typeSeqCode.replace(skips[i], String.valueOf(Integer.parseInt(skips[i]) + step));
                if (typeSeqCode.length() > len && !isUpGrade) {
                    cnt = 0;
                    typeSeqCode = "";
                    break;
                }
                isSkip = true;
                ++cnt;
                break;
            }
            if (isSkip && cnt <= 5) {
                TicketRuleCodeHelper.getSkipCode(skip, step, len, isUpGrade, typeSeqCode);
            } else if (cnt == 0) {
                typeSeqCode = String.valueOf(Integer.parseInt(initial) + step);
            } else {
                cnt = 0;
            }
        }
        initial = typeSeqCode;
    }

    private static String getTicketCode(String skip, int step, int len, boolean isUpGrade, String init) {
        String seqCode = String.valueOf(Integer.parseInt(init) + step);
        if (step == 0) {
            ++step;
        }
        boolean isSkip = false;
        if (skip == null) {
            return seqCode;
        }
        String[] skips = skip.split(",");
        if (skips.length > 1) {
            for (int i = 1; i <= 6; ++i) {
                boolean isBreak = false;
                for (int j = 1; j < skips.length; ++j) {
                    if (skips[j].isEmpty()) continue;
                    if (seqCode.contains(skips[j])) {
                        init = seqCode = seqCode.replace(skips[j], String.valueOf(Integer.parseInt(skips[j]) + step));
                        if (seqCode.length() > len && !isUpGrade) {
                            seqCode = "";
                            break;
                        }
                        isSkip = true;
                        break;
                    }
                    if (j != skips.length - 1 || !isSkip) continue;
                    isBreak = true;
                }
                if (!isSkip || seqCode.isEmpty() || isBreak) break;
            }
        }
        if (!isSkip) {
            seqCode = String.valueOf(Integer.parseInt(init) + step);
        }
        return seqCode;
    }

    public static String getRandom(int len) {
        String source = "0123456789";
        StringBuilder rs = new StringBuilder();
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < len; ++i) {
            rs.append(source.charAt(secureRandom.nextInt(10)));
        }
        return rs.toString();
    }
}

