/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketSaleOrderFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketMakeColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketMakeColl == null || ticketMakeColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> ticketActionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketMakeColl.length);
        Date bizDate = TimeServiceHelper.now();
        for (DynamicObject temp : ticketMakeColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(temp.getString("giftbillno"));
            ticketActionFlowVO.setTicketID(((Long)temp.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketSaleOrderFlowProcessor.getBaseDataLongPkId(temp, "tickettypeid"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setBranchID(TicketSaleOrderFlowProcessor.getBaseDataLongPkId(temp, "giftbranchid"));
            ticketActionFlowVO.setOrgID(TicketSaleOrderFlowProcessor.getBaseDataLongPkId(temp, "giftorgid"));
            ticketActionFlowVO.setBizDate(temp.getDate("gifttime") != null ? temp.getDate("gifttime") : bizDate);
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.SEND.getName());
            ticketActionFlowVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue());
            ticketActionFlowVO.setOperatorID(TicketSaleOrderFlowProcessor.getBaseDataLongPkId(temp, "gifterid"));
            ticketActionFlowVOS.add(ticketActionFlowVO);
        }
        return ticketActionFlowVOS;
    }
}

