/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoDistributeProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoGiftProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoMakeProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoPayProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoPublishProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoQueryDetailProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoQueryListProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoReceiveProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoRecycleProcessor;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoRefundProcessor;

public class TicketsInfoProcessorFactory {
    private static final Map<String, TicketInfoProcessor> processorRepository = new HashMap<String, TicketInfoProcessor>(16);

    public static TicketInfoProcessor getProcessor(String billFormId) {
        if (StringUtils.isEmpty((CharSequence)billFormId)) {
            return null;
        }
        TicketInfoProcessor processor = null;
        switch (billFormId) {
            case "gcm_ticketsmake": {
                processor = processorRepository.get("gcm_ticketsmake");
                break;
            }
            case "gcm_issuescheme": {
                processor = processorRepository.get("gcm_issuescheme");
                break;
            }
            case "gcm_ticketreceive": {
                processor = processorRepository.get("gcm_ticketreceive");
                break;
            }
            case "gcm_ticketspublish": {
                processor = processorRepository.get("gcm_ticketspublish");
                break;
            }
            case "gcm_ticketsreturn": {
                processor = processorRepository.get("gcm_ticketsreturn");
                break;
            }
            case "pos_salesorder": {
                processor = processorRepository.get("pos_salesorder");
                break;
            }
            case "gcm_ticketquerylist": {
                processor = processorRepository.get("gcm_ticketquerylist");
                break;
            }
            case "gcm_ticketpay": {
                processor = processorRepository.get("gcm_ticketpay");
                break;
            }
            case "gcm_ticketrefund": {
                processor = processorRepository.get("gcm_ticketrefund");
                break;
            }
            case "gcm_ticketquerydetail": {
                processor = processorRepository.get("gcm_ticketquerydetail");
                break;
            }
        }
        return processor;
    }

    static {
        processorRepository.put("gcm_ticketsmake", new TicketInfoMakeProcessor());
        processorRepository.put("gcm_issuescheme", new TicketInfoDistributeProcessor());
        processorRepository.put("gcm_ticketreceive", new TicketInfoReceiveProcessor());
        processorRepository.put("gcm_ticketspublish", new TicketInfoPublishProcessor());
        processorRepository.put("gcm_ticketsreturn", new TicketInfoRecycleProcessor());
        processorRepository.put("pos_salesorder", new TicketInfoGiftProcessor());
        processorRepository.put("gcm_ticketquerylist", new TicketInfoQueryListProcessor());
        processorRepository.put("gcm_ticketquerydetail", new TicketInfoQueryDetailProcessor());
        processorRepository.put("gcm_ticketpay", new TicketInfoPayProcessor());
        processorRepository.put("gcm_ticketrefund", new TicketInfoRefundProcessor());
    }
}

