/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowProcessor;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketActionFlowVO;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketsMakeFlowProcessor
extends TicketActionFlowProcessor {
    @Override
    public List<TicketActionFlowVO> getTicketActionFlow(TicketFlowParamVO ticketFlowParamVO) {
        DynamicObject[] ticketMakeColl = BusinessDataServiceHelper.load((Object[])ticketFlowParamVO.getBillIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gcm_ticketsinfo"));
        if (ticketMakeColl == null || ticketMakeColl.length < 1) {
            return new ArrayList<TicketActionFlowVO>(0);
        }
        ArrayList<TicketActionFlowVO> ticketActionFlowVOS = new ArrayList<TicketActionFlowVO>(ticketMakeColl.length);
        for (DynamicObject dyn : ticketMakeColl) {
            TicketActionFlowVO ticketActionFlowVO = new TicketActionFlowVO();
            ticketActionFlowVO.setBillNo(dyn.getString("makebillno"));
            ticketActionFlowVO.setTicketID(((Long)dyn.getPkValue()).longValue());
            ticketActionFlowVO.setTicketTypeID(TicketsMakeFlowProcessor.getBaseDataLongPkId(dyn, "tickettypeid"));
            ticketActionFlowVO.setOperType(ticketFlowParamVO.getOperType().getValue());
            ticketActionFlowVO.setTicketStatus(TicketStatusEnum.NO_MAKE.getName());
            ticketActionFlowVO.setBizDate(dyn.getDate("maketime") != null ? dyn.getDate("maketime") : TimeServiceHelper.now());
            ticketActionFlowVO.setBillFormID(ticketFlowParamVO.getBillFormId());
            ticketActionFlowVO.setBranchID(TicketsMakeFlowProcessor.getBaseDataLongPkId(dyn, "makebranchid"));
            ticketActionFlowVO.setComment(dyn.getString("comment"));
            ticketActionFlowVO.setOrgID(TicketsMakeFlowProcessor.getBaseDataLongPkId(dyn, "makeorgid"));
            ticketActionFlowVO.setOperatorID(TicketsMakeFlowProcessor.getBaseDataLongPkId(dyn, "makerid"));
            ticketActionFlowVOS.add(ticketActionFlowVO);
        }
        return ticketActionFlowVOS;
    }
}

