/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.payhelper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.drp.dbd.common.pay.ali.vo.TradeCancelRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradePayRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradeQueryRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradeRefundRequestParam;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.common.pay.util.AliPayUtil;
import kd.drp.dbd.common.pay.util.PayUtil;

public class AliPayTradeHelper {
    public static JSONObject tradePay(Map<String, String> aliConfig, CheckOutCounterInfo payData, String authCode, BigDecimal payAmount) {
        String billNo = payData.getBillNo();
        long storeId = payData.getStoreId();
        String outTradeNo = PayUtil.genOutTradeNo();
        String subject = payData.getSubject();
        long operatorId = payData.getOperatorId();
        Date operaTime = payData.getOperaTime();
        TradePayRequestParam tradePayRequestParam = new TradePayRequestParam(aliConfig, billNo, operatorId, operaTime);
        tradePayRequestParam.setScene("bar_code");
        tradePayRequestParam.setTimeoutExpress("2m");
        tradePayRequestParam.setOutTradeNo(outTradeNo);
        tradePayRequestParam.setAuthCode(authCode);
        tradePayRequestParam.setSubject(subject);
        tradePayRequestParam.setStoreId(Long.toString(storeId));
        tradePayRequestParam.setTotalAmount(payAmount);
        JSONObject alipayTradePayResponse = AliPayUtil.tradePay((TradePayRequestParam)tradePayRequestParam);
        if (alipayTradePayResponse == null) {
            alipayTradePayResponse = new JSONObject();
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.FAILED);
            return alipayTradePayResponse;
        }
        if ("10000".equals(alipayTradePayResponse.getString("code"))) {
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
        } else if ("10003".equals(alipayTradePayResponse.getString("code"))) {
            JSONObject loopQueryResponse = AliPayTradeHelper.loopQueryResult(aliConfig, billNo, outTradeNo, operatorId, operaTime);
            alipayTradePayResponse = AliPayTradeHelper.checkQueryAndCancel(outTradeNo, loopQueryResponse, alipayTradePayResponse, aliConfig, billNo, operatorId, operaTime);
        } else if (AliPayTradeHelper.tradeError(alipayTradePayResponse)) {
            JSONObject queryResponse = AliPayTradeHelper.tradeQuery(aliConfig, billNo, "", outTradeNo, operatorId, operaTime);
            alipayTradePayResponse = AliPayTradeHelper.checkQueryAndCancel(outTradeNo, queryResponse, alipayTradePayResponse, aliConfig, billNo, operatorId, operaTime);
        } else {
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.FAILED);
        }
        return alipayTradePayResponse;
    }

    private static JSONObject loopQueryResult(Map<String, String> aliConfig, String billNo, String outTradeNo, long operatorId, Date operaTime) {
        JSONObject queryResult = null;
        for (int i = 0; i < 5; ++i) {
            PayUtil.sleep((long)5000L);
            JSONObject alipayTradeQueryResponse = AliPayTradeHelper.tradeQuery(aliConfig, billNo, "", outTradeNo, operatorId, operaTime);
            if (alipayTradeQueryResponse == null) continue;
            if (AliPayTradeHelper.stopQuery(alipayTradeQueryResponse)) {
                return alipayTradeQueryResponse;
            }
            queryResult = alipayTradeQueryResponse;
        }
        return queryResult;
    }

    protected static boolean stopQuery(JSONObject response) {
        return "10000".equals(response.getString("code")) && ("TRADE_FINISHED".equals(response.getString("trade_status")) || "TRADE_SUCCESS".equals(response.getString("trade_status")) || "TRADE_CLOSED".equals(response.getString("trade_status")));
    }

    protected static JSONObject checkQueryAndCancel(String outTradeNo, JSONObject queryResponse, JSONObject alipayTradePayResponse, Map<String, String> aliConfig, String billNo, long opUserId, Date opTime) {
        if (AliPayTradeHelper.querySuccess(queryResponse)) {
            alipayTradePayResponse.put("code", (Object)"10000");
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
            return alipayTradePayResponse;
        }
        JSONObject cancelResponse = AliPayTradeHelper.tradeCancel(aliConfig, billNo, "", outTradeNo, opUserId, opTime);
        if (AliPayTradeHelper.tradeError(cancelResponse)) {
            alipayTradePayResponse.put("code", (Object)"20000");
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.UNKNOWN);
        } else {
            alipayTradePayResponse.put("code", (Object)"40004");
            alipayTradePayResponse.put("payStatus", (Object)TradeStatus.FAILED);
        }
        return alipayTradePayResponse;
    }

    protected static boolean tradeError(JSONObject response) {
        return response == null || "20000".equals(response.getString("code"));
    }

    protected static boolean querySuccess(JSONObject response) {
        return response != null && "10000".equals(response.getString("code")) && ("TRADE_SUCCESS".equals(response.getString("trade_status")) || "TRADE_FINISHED".equals(response.getString("trade_status")));
    }

    public static JSONObject tradeQuery(Map<String, String> aliConfig, String billNo, String tradeNo, String outTradeNo, long opUserId, Date opTime) {
        TradeQueryRequestParam tradeQueryRequestParam = new TradeQueryRequestParam(aliConfig, billNo, opUserId, opTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            tradeQueryRequestParam.setTradeNo(tradeNo);
        }
        tradeQueryRequestParam.setOutTradeNo(outTradeNo);
        return AliPayUtil.tradeQuery((TradeQueryRequestParam)tradeQueryRequestParam);
    }

    public static JSONObject tradeRefund(Map<String, String> aliConfig, RefundInfo refundData, String tradeNo, String outTradeNo, BigDecimal refundAmount) {
        String billNo = refundData.getBillNo();
        long operatorId = refundData.getOperatorId();
        Date operaTime = refundData.getOperaTime();
        long storeId = refundData.getStoreId();
        TradeRefundRequestParam tradeRefundRequestParam = new TradeRefundRequestParam(aliConfig, billNo, operatorId, operaTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            tradeRefundRequestParam.setTradeNo(tradeNo);
        }
        String outRequestNo = billNo + PayUtil.genOutTradeNo();
        tradeRefundRequestParam.setOutTradeNo(outTradeNo);
        tradeRefundRequestParam.setRefundAmount(refundAmount);
        tradeRefundRequestParam.setStoreId(Long.toString(storeId));
        tradeRefundRequestParam.setOutRequestNo(outRequestNo);
        JSONObject refundResponse = AliPayUtil.tradeRefund((TradeRefundRequestParam)tradeRefundRequestParam);
        if (refundResponse == null) {
            refundResponse = new JSONObject();
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
            return refundResponse;
        }
        if ("10000".equals(refundResponse.getString("code")) && "Y".equals(refundResponse.getString("fund_change"))) {
            refundResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
        } else if ("10000".equals(refundResponse.getString("code")) && "N".equals(refundResponse.getString("fund_change"))) {
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
            refundResponse.put("sub_msg", (Object)"\u8ba2\u5355\u5df2\u5168\u989d\u9000\u6b3e");
        } else if (AliPayTradeHelper.tradeError(refundResponse)) {
            refundResponse.put("payStatus", (Object)TradeStatus.UNKNOWN);
        } else {
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
        }
        return refundResponse;
    }

    public static JSONObject tradeCancel(Map<String, String> aliConfig, String billNo, String tradeNo, String outTradeNo, long opUserId, Date opTime) {
        TradeCancelRequestParam tradeCancelRequestParam = new TradeCancelRequestParam(aliConfig, billNo, opUserId, opTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            tradeCancelRequestParam.setTradeNo(tradeNo);
        }
        tradeCancelRequestParam.setOutTradeNo(outTradeNo);
        return AliPayUtil.tradeCancel((TradeCancelRequestParam)tradeCancelRequestParam);
    }
}

