/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.payhelper;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.business.payhelper.PayTradeServiceFactory;
import kd.drp.dbd.business.payinterface.IPayTradeService;
import kd.drp.dbd.common.enums.ControlModeEnum;
import kd.drp.dbd.common.enums.StatusEnum;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.PayResult;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.RefundResult;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.common.pay.exception.ServiceException;

public class PayTradeHelper {
    public static PayResult getPayData(CheckOutCounterInfo payData, long payChannelId, String authCode, BigDecimal payAmount) {
        PayResult payResult = new PayResult();
        if (payData == null) {
            String error_msg = "\u6536\u6b3e\u754c\u9762\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!";
            payResult.setErrorMessage(error_msg);
            payResult.setTradeStatus(TradeStatus.FAILED);
            return payResult;
        }
        String payDataVal = PayTradeHelper.payDataValidate(payData, payChannelId, authCode, payAmount);
        if (StringUtils.isNotEmpty((String)payDataVal)) {
            payResult.setErrorMessage(payDataVal);
            payResult.setTradeStatus(TradeStatus.FAILED);
            return payResult;
        }
        IPayTradeService IPayTradeService2 = PayTradeServiceFactory.getPayTradeService(payChannelId);
        if (IPayTradeService2 == null) {
            payResult.setErrorMessage("\u83b7\u53d6\u63a5\u53e3\u5b9e\u4f8b\u5931\u8d25");
            payResult.setTradeStatus(TradeStatus.FAILED);
            return payResult;
        }
        long storeId = payData.getStoreId();
        Map<String, String> payConfig = PayTradeHelper.setPayConfig(payChannelId, storeId);
        if (payConfig.isEmpty()) {
            payResult.setErrorMessage("\u8bf7\u7ef4\u62a4\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f");
            payResult.setTradeStatus(TradeStatus.FAILED);
            return payResult;
        }
        JSONObject payResponse = new JSONObject();
        try {
            payResponse = IPayTradeService2.tradePay(payConfig, payData, authCode, payAmount);
        }
        catch (Exception e) {
            StringBuilder errorMsg = new StringBuilder("\u652f\u4ed8\u65b9\u6cd5\u8c03\u7528\u5f02\u5e38:");
            Gson gson = new Gson();
            errorMsg.append(gson.toJson((Object)e));
            payResult.setErrorMessage(errorMsg.toString());
            payResult.setTradeStatus(TradeStatus.FAILED);
            return payResult;
        }
        payResult.setPayResponse(payResponse);
        if (payResponse != null && TradeStatus.SUCCESS.toString().equals(payResponse.getString("payStatus"))) {
            payResult.setTradeStatus(TradeStatus.SUCCESS);
        } else if (payResponse != null && TradeStatus.UNKNOWN.toString().equals(payResponse.getString("payStatus"))) {
            payResult.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            payResult.setTradeStatus(TradeStatus.FAILED);
        }
        return payResult;
    }

    protected static String payDataValidate(CheckOutCounterInfo payData, long payChannelId, String authCode, BigDecimal payAmount) {
        String error_msg = "";
        if (payChannelId <= 0L) {
            error_msg = "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        if (StringUtils.isEmpty((String)authCode)) {
            error_msg = "\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        if (payAmount == null || payAmount.compareTo(BigDecimal.ZERO) <= 0) {
            error_msg = "\u8ba2\u5355\u91d1\u989d\u9700\u5927\u4e8e\u96f6!";
            return error_msg;
        }
        if (StringUtils.isEmpty((String)payData.getSubject()) && StringUtils.isEmpty((String)payData.getBody())) {
            error_msg = "\u8ba2\u5355\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        if (payData.getStoreId() <= 0L) {
            error_msg = "\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        return error_msg;
    }

    public static RefundResult getRefundData(RefundInfo refundData, long payChannelId, String tradeNo, String outTradeNo, BigDecimal refundAmount) {
        RefundResult refundResult = new RefundResult();
        if (refundData == null) {
            refundResult.setErrorMessage("\u9000\u6b3e\u754c\u9762\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
            refundResult.setTradeStatus(TradeStatus.FAILED);
            return refundResult;
        }
        String refundDataVal = PayTradeHelper.refundDataValidate(refundData, payChannelId, tradeNo, outTradeNo, refundAmount);
        if (StringUtils.isNotEmpty((String)refundDataVal)) {
            refundResult.setErrorMessage(refundDataVal);
            refundResult.setTradeStatus(TradeStatus.FAILED);
            return refundResult;
        }
        IPayTradeService IPayTradeService2 = PayTradeServiceFactory.getPayTradeService(payChannelId);
        if (IPayTradeService2 == null) {
            refundResult.setErrorMessage("\u83b7\u53d6\u63a5\u53e3\u5b9e\u4f8b\u5931\u8d25");
            refundResult.setTradeStatus(TradeStatus.FAILED);
            return refundResult;
        }
        long storeId = refundData.getStoreId();
        Map<String, String> payConfig = PayTradeHelper.setPayConfig(payChannelId, storeId);
        if (payConfig.isEmpty()) {
            refundResult.setErrorMessage("\u8bf7\u7ef4\u62a4\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f");
            refundResult.setTradeStatus(TradeStatus.FAILED);
            return refundResult;
        }
        JSONObject refundResponse = new JSONObject();
        try {
            refundResponse = IPayTradeService2.tradeRefund(payConfig, refundData, tradeNo, outTradeNo, refundAmount);
        }
        catch (Exception e) {
            refundResult.setErrorMessage("\u9000\u6b3e\u65b9\u6cd5\u8c03\u7528\u5f02\u5e38!" + e.getMessage());
            refundResult.setTradeStatus(TradeStatus.FAILED);
            return refundResult;
        }
        refundResult.setRefundResponse(refundResponse);
        if (refundResponse != null && TradeStatus.SUCCESS.toString().equals(refundResponse.getString("payStatus"))) {
            refundResult.setTradeStatus(TradeStatus.SUCCESS);
        } else if (refundResponse != null && TradeStatus.UNKNOWN.toString().equals(refundResponse.getString("payStatus"))) {
            refundResult.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            refundResult.setTradeStatus(TradeStatus.FAILED);
        }
        return refundResult;
    }

    protected static String refundDataValidate(RefundInfo refundData, long payChannelId, String tradeNo, String outTradeNo, BigDecimal refundAmount) {
        String error_msg = "";
        if (payChannelId <= 0L) {
            error_msg = "\u652f\u4ed8\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        if (refundAmount == null || refundAmount.compareTo(BigDecimal.ZERO) <= 0) {
            error_msg = "\u9000\u6b3e\u91d1\u989d\u9700\u5927\u4e8e\u96f6!";
            return error_msg;
        }
        if (StringUtils.isEmpty((String)tradeNo) && StringUtils.isEmpty((String)outTradeNo)) {
            error_msg = "\u4ea4\u6613\u53f7\u548c\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!";
            return error_msg;
        }
        if (refundData.getStoreId() <= 0L) {
            error_msg = "\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
            return error_msg;
        }
        return error_msg;
    }

    protected static IPayTradeService getPayTradeService(long payChannelId) {
        Class<?> clazz = null;
        IPayTradeService IPayTradeService2 = null;
        DynamicObject payChannelInfo = BusinessDataServiceHelper.loadSingle((Object)payChannelId, (String)"dbd_paymode");
        if (payChannelInfo == null) {
            throw new ServiceException("\u83b7\u53d6\u652f\u4ed8\u901a\u9053\u4fe1\u606f\u5931\u8d25");
        }
        String serviceAddr = payChannelInfo.getString("service");
        if (StringUtils.isEmpty((String)serviceAddr)) {
            throw new ServiceException("\u83b7\u53d6\u63a5\u53e3\u5b9e\u4f8b\u5931\u8d25");
        }
        try {
            clazz = Class.forName(serviceAddr);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e.getMessage(), (Exception)e);
        }
        try {
            IPayTradeService2 = (IPayTradeService)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceException(e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e.getMessage(), (Exception)e);
        }
        return IPayTradeService2;
    }

    protected static Map<String, String> setPayConfig(long payChannelId, long storeId) {
        QFilter qFilter = new QFilter("entryentity.channel.Id", "=", (Object)payChannelId);
        qFilter.and("status", "=", (Object)StatusEnum.AUDIT.getValue());
        qFilter.and("treeentryentity.branch.Id", "=", (Object)storeId);
        DynamicObjectCollection payChannelDatas = PayTradeHelper.queryPayConfig(qFilter);
        if (payChannelDatas == null || payChannelDatas.size() == 0) {
            QFilter filter = new QFilter("entryentity.channel.Id", "=", (Object)payChannelId);
            filter.and("status", "=", (Object)StatusEnum.AUDIT.getValue());
            filter.and("controlmode", "=", (Object)ControlModeEnum.ALLSTORE.getValue());
            payChannelDatas = PayTradeHelper.queryPayConfig(filter);
        }
        HashMap<String, String> payConfig = new HashMap<String, String>(8);
        if (payChannelDatas != null && payChannelDatas.size() > 0) {
            for (DynamicObject payChannelData : payChannelDatas) {
                payConfig.put(payChannelData.getString("entryentity.subentryentity.paramkey"), payChannelData.getString("entryentity.subentryentity.paramvalue"));
            }
        }
        return payConfig;
    }

    private static DynamicObjectCollection queryPayConfig(QFilter qFilter) {
        DynamicObjectCollection payChannelDatas = QueryServiceHelper.query((String)"dbd_payconfigs", (String)"id,entryentity.id,entryentity.subentryentity.id,entryentity.subentryentity.paramkey,entryentity.subentryentity.paramvalue", (QFilter[])new QFilter[]{qFilter});
        return payChannelDatas;
    }
}

