/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.payhelper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.drp.dbd.business.payhelper.PayTradeHelper;
import kd.drp.dbd.business.payinterface.IPayTradeService;

public class PayTradeServiceFactory {
    private static final Map<String, IPayTradeService> _PayTradeServiceCache = new ConcurrentHashMap<String, IPayTradeService>();

    public static final IPayTradeService getPayTradeService(long payChannelId) {
        IPayTradeService payTradeService = _PayTradeServiceCache.get(PayTradeServiceFactory.getKey(payChannelId));
        if (payTradeService == null) {
            payTradeService = PayTradeServiceFactory.setPayTradeService(payChannelId);
        }
        return payTradeService;
    }

    private static final IPayTradeService setPayTradeService(long payChannelId) {
        IPayTradeService payTradeService = PayTradeHelper.getPayTradeService(payChannelId);
        _PayTradeServiceCache.put(PayTradeServiceFactory.getKey(payChannelId), payTradeService);
        return payTradeService;
    }

    private static final String getKey(long payChannelId) {
        String accountId = RequestContext.get().getAccountId();
        return String.format("%s%s%s", payChannelId, "_", accountId);
    }

    private static void remove(long payChannelId) {
        _PayTradeServiceCache.remove(PayTradeServiceFactory.getKey(payChannelId));
    }
}

