/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.payhelper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.common.pay.util.PayUtil;
import kd.drp.dbd.common.pay.util.WechatPayUtil;
import kd.drp.dbd.common.pay.wechat.vo.MicroPayRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.OrderQueryRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.RefundRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.ReverseRequestParam;

public class WxPayTradeHelper {
    public static JSONObject tradePay(Map<String, String> aliConfig, CheckOutCounterInfo payData, String authCode, BigDecimal payAmount) {
        String billNo = payData.getBillNo();
        long storeId = payData.getStoreId();
        String outTradeNo = PayUtil.genOutTradeNo();
        String body = payData.getBody();
        long operatorId = payData.getOperatorId();
        Date operaTime = payData.getOperaTime();
        String spbillCreateIp = payData.getSpbillCreateIp();
        MicroPayRequestParam microPayRequestParam = new MicroPayRequestParam(aliConfig, billNo, operatorId, operaTime);
        microPayRequestParam.setOutTradeNo(outTradeNo);
        microPayRequestParam.setBody(body);
        microPayRequestParam.setSpbillCreateIp(spbillCreateIp);
        microPayRequestParam.setAuthCode(authCode);
        microPayRequestParam.setTotalFee(payAmount.multiply(new BigDecimal("100")).intValue());
        microPayRequestParam.setDeviceInfo(Long.toString(storeId));
        JSONObject microPayResponse = WechatPayUtil.microPay((MicroPayRequestParam)microPayRequestParam);
        if (microPayResponse == null) {
            microPayResponse = new JSONObject();
            microPayResponse.put("payStatus", (Object)TradeStatus.FAILED);
            return microPayResponse;
        }
        if ("FAIL".equals(microPayResponse.getString("return_code"))) {
            microPayResponse.put("payStatus", (Object)TradeStatus.FAILED);
        } else if ("FAIL".equals(microPayResponse.getString("result_code"))) {
            if ("SYSTEMERROR".equals(microPayResponse.getString("err_code")) || "BANKERROR".equals(microPayResponse.getString("err_code")) || "USERPAYING".equals(microPayResponse.getString("err_code"))) {
                JSONObject queryResponse = WxPayTradeHelper.loopQueryResult(aliConfig, billNo, outTradeNo, operatorId, operaTime);
                microPayResponse = WxPayTradeHelper.checkQueryAndCancel(outTradeNo, queryResponse, microPayResponse, aliConfig, billNo, operatorId, operaTime, storeId);
                microPayResponse.put("trade_no", (Object)microPayResponse.getString("transaction_id"));
            } else {
                microPayResponse.put("payStatus", (Object)TradeStatus.FAILED);
            }
        } else {
            microPayResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
            microPayResponse.put("trade_no", (Object)microPayResponse.getString("transaction_id"));
        }
        return microPayResponse;
    }

    private static JSONObject loopQueryResult(Map<String, String> aliConfig, String billNo, String outTradeNo, long operatorId, Date operaTime) {
        JSONObject queryResult = null;
        for (int i = 0; i < 5; ++i) {
            PayUtil.sleep((long)5000L);
            JSONObject WXTradeQueryResponse = WxPayTradeHelper.tradeQuery(aliConfig, billNo, "", outTradeNo, operatorId, operaTime);
            if (WXTradeQueryResponse == null) continue;
            if (WxPayTradeHelper.stopQuery(WXTradeQueryResponse)) {
                return WXTradeQueryResponse;
            }
            queryResult = WXTradeQueryResponse;
        }
        return queryResult;
    }

    protected static boolean stopQuery(JSONObject response) {
        return "SUCCESS".equals(response.getString("return_code")) && "SUCCESS".equals(response.getString("result_code")) && ("SUCCESS".equals(response.getString("trade_state")) || "REVOKED".equals(response.getString("trade_state")) || "CLOSED".equals(response.getString("trade_state")) || "PAYERROR".equals(response.getString("trade_state")));
    }

    protected static JSONObject checkQueryAndCancel(String outTradeNo, JSONObject queryResponse, JSONObject payResponse, Map<String, String> aliConfig, String billNo, long opUserId, Date opTime, long storeId) {
        if (WxPayTradeHelper.querySuccess(queryResponse)) {
            payResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
            payResponse.put("out_trade_no", (Object)outTradeNo);
            payResponse.put("transaction_id", (Object)queryResponse.getString("transaction_id"));
            return payResponse;
        }
        WxPayTradeHelper.tradeCancel(aliConfig, billNo, "", outTradeNo, opUserId, opTime, storeId);
        payResponse.put("payStatus", (Object)TradeStatus.FAILED);
        return payResponse;
    }

    protected static boolean querySuccess(JSONObject response) {
        return response != null && "SUCCESS".equals(response.getString("return_code")) && "SUCCESS".equals(response.getString("result_code")) && "SUCCESS".equals(response.getString("trade_state"));
    }

    public static JSONObject tradeQuery(Map<String, String> aliConfig, String billNo, String tradeNo, String outTradeNo, long opUserId, Date opTime) {
        OrderQueryRequestParam orderQueryRequestParam = new OrderQueryRequestParam(aliConfig, billNo, opUserId, opTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            orderQueryRequestParam.setTransactionId(tradeNo);
        }
        orderQueryRequestParam.setOutTradeNo(outTradeNo);
        return WechatPayUtil.orderQuery((OrderQueryRequestParam)orderQueryRequestParam);
    }

    public static JSONObject tradeRefund(Map<String, String> aliConfig, RefundInfo refundData, String tradeNo, String outTradeNo, BigDecimal refundAmount) {
        String billNo = refundData.getBillNo();
        long operatorId = refundData.getOperatorId();
        Date operaTime = refundData.getOperaTime();
        JSONObject tradeQuery = WxPayTradeHelper.tradeQuery(aliConfig, billNo, tradeNo, outTradeNo, operatorId, operaTime);
        JSONObject refundResponse = new JSONObject();
        if (tradeQuery == null) {
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
            return refundResponse;
        }
        int totalFee = tradeQuery.getIntValue("total_fee");
        tradeNo = tradeQuery.getString("transaction_id");
        RefundRequestParam refundRequestParam = new RefundRequestParam(aliConfig, billNo, operatorId, operaTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            refundRequestParam.setTransactionId(tradeNo);
        }
        refundRequestParam.setOutTradeNo(outTradeNo);
        String outRefundNo = PayUtil.genOutTradeNo();
        refundRequestParam.setOutRefundNo(outRefundNo);
        refundRequestParam.setRefundFee(refundAmount.multiply(new BigDecimal("100")).intValue());
        refundRequestParam.setTotalFee(totalFee);
        refundResponse = WechatPayUtil.refund((RefundRequestParam)refundRequestParam);
        if (refundResponse == null) {
            refundResponse = new JSONObject();
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
            return refundResponse;
        }
        refundResponse.put("trade_no", (Object)refundResponse.getString("refund_id"));
        if ("FAIL".equals(refundResponse.getString("return_code"))) {
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
        } else if ("FAIL".equals(refundResponse.getString("result_code"))) {
            refundResponse.put("payStatus", (Object)TradeStatus.FAILED);
        } else {
            refundResponse.put("payStatus", (Object)TradeStatus.SUCCESS);
        }
        return refundResponse;
    }

    public static JSONObject tradeCancel(Map<String, String> aliConfig, String billNo, String tradeNo, String outTradeNo, long opUserId, Date opTime, long stordId) {
        ReverseRequestParam reverseRequestParam = new ReverseRequestParam(aliConfig, billNo, opUserId, opTime);
        if (StringUtil.isNotEmpty((CharSequence)tradeNo)) {
            reverseRequestParam.setTransactionId(tradeNo);
        }
        reverseRequestParam.setOutTradeNo(outTradeNo);
        return WechatPayUtil.reverse((ReverseRequestParam)reverseRequestParam);
    }
}

