/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoSaveProcessor;
import kd.drp.dbd.enums.TicketSourceTypeEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;
import kd.drp.dbd.utils.CalendarUtil;

public class TicketInfoDistributeProcessor
extends TicketInfoSaveProcessor {
    @Override
    public List<TicketsInfoVO> convertDyn2VO(DynamicObject ticketDistributeDyn) {
        int ticketDistributeQty = 0;
        if (null == ticketDistributeDyn) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6d3e\u53d1\u793c\u5238\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570", (String)"TicketInfoDistributeProcessor_0", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        ticketDistributeQty = ticketDistributeDyn.getInt("totalqty");
        if (ticketDistributeQty <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d3e\u53d1\u6570\u91cf", (String)"TicketInfoDistributeProcessor_1", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        long ticketTypeID = this.getBaseDataLongPkId(ticketDistributeDyn, "tickettypeid");
        DynamicObject ticketsTypeDyn = this.getBaseDataByPkId(ticketTypeID, "gcm_ticketstype");
        ArrayList<TicketsInfoVO> TicketsInfoVOList = new ArrayList<TicketsInfoVO>(ticketDistributeQty);
        for (int i = 0; i < ticketDistributeQty; ++i) {
            TicketsInfoVO vo = new TicketsInfoVO();
            vo.setTicketTypeID(ticketTypeID);
            vo.setTicketQty(Integer.valueOf(ticketDistributeQty));
            vo.setTicketStatus(TicketStatusEnum.SEND.getName());
            vo.setSouceType(TicketSourceTypeEnum.DISTRIBUTE.getName());
            vo.setComment(ticketDistributeDyn.getString("comment"));
            this.setValidityDays(vo, ticketDistributeDyn, ticketsTypeDyn);
            vo.setAdTotalQty(Integer.valueOf(ticketDistributeDyn.getInt("totalqty")));
            vo.setTicketDistributeID(ticketDistributeDyn.getLong("id"));
            vo.setBizOrgID(this.getBaseDataLongPkId(ticketDistributeDyn, "bizorgid"));
            this.setPropertyByTicketType(vo, ticketsTypeDyn);
            TicketsInfoVOList.add(vo);
        }
        return TicketsInfoVOList;
    }

    @Override
    protected void setValidityDays(TicketsInfoVO vo, DynamicObject ticketDistributeDyn, DynamicObject ticketsTypeDyn) {
        Date startDate = ticketDistributeDyn.getDate("startdate");
        Date endDate = ticketDistributeDyn.getDate("enddate");
        int relativeDays = ticketDistributeDyn.getInt("relativedays");
        Integer dayInterval = 0;
        if (ObjectUtils.isEmpty((Object)startDate) && ObjectUtils.isEmpty((Object)endDate) && relativeDays <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u793c\u5238\u6d3e\u53d1\u76f8\u5bf9\u5929\u6570\u6216\u8005\u6709\u6548\u65e5\u671f", (String)"TicketInfoDistributeProcessor_2", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        if (!ObjectUtils.isEmpty((Object)startDate) && !ObjectUtils.isEmpty((Object)endDate)) {
            dayInterval = CalendarUtil.calculateDayInterval((Date)startDate, (Date)endDate);
        }
        if (ObjectUtils.isEmpty((Object)startDate) && ObjectUtils.isEmpty((Object)endDate) && relativeDays >= 0) {
            Date now = new Date();
            startDate = CalendarUtil.getDayStartTime((Date)now);
            endDate = CalendarUtil.getDayEndTime((Date)now);
            endDate = CalendarUtil.calculateDayAdd((Date)endDate, (int)(relativeDays - 1));
            dayInterval = relativeDays;
        }
        vo.setValiditydDays(dayInterval);
        vo.setStartTime(startDate);
        vo.setEndtime(endDate);
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    void setBizInfo(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
        ticketsInfoDyn.set("ticketsdistributeid", (Object)vo.getTicketDistributeID());
    }
}

