/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoSaveProcessor;
import kd.drp.dbd.enums.TicketSourceTypeEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;
import kd.drp.dbd.utils.CalendarUtil;

public class TicketInfoGiftProcessor
extends TicketInfoSaveProcessor {
    @Override
    List<TicketsInfoVO> convertDyn2VO(DynamicObject dynamicObject) {
        return null;
    }

    @Override
    public List<TicketsInfoVO> doProcess(TicketInfoParamVO ticketInfoParamVo) {
        List billIds = ticketInfoParamVo.getBillIds();
        String billSource = ticketInfoParamVo.getBillSource();
        DynamicObject retailBillDyn = this.loadDynamicObject((Long)billIds.get(0), billSource);
        String retailBillSaleStatus = retailBillDyn.getString("salestatus");
        if (StringUtils.equals((CharSequence)"S", (CharSequence)retailBillSaleStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u8d60\u9001\u793c\u5238", (String)"TicketInfoGiftProcessor_0", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection ticketInfoGiftEntryColl = retailBillDyn.getDynamicObjectCollection("ticketsendentity");
        ArrayList<TicketsInfoVO> ticketsInfoVOLists = new ArrayList<TicketsInfoVO>(10);
        for (DynamicObject ticketInfoGiftEntryDyn : ticketInfoGiftEntryColl) {
            List<TicketsInfoVO> ticketsInfoVOList = this.convertDyn2VO(ticketInfoGiftEntryDyn, retailBillDyn);
            if (CollectionUtils.isEmpty(ticketsInfoVOList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u793c\u5238\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01", (String)"TicketInfoGiftProcessor_1", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            Long ticketTypeId = ticketsInfoVOList.get(0).getTicketTypeID();
            try {
                lock.lock();
                Map<String, Object> ticketInfoDynMap = this.batchBuildTicketInfo(ticketsInfoVOList, ticketTypeId);
                List ticketsInfoDynList = (List)ticketInfoDynMap.get("data");
                String realQty = (String)ticketInfoDynMap.get("init");
                this.batchSaveTicketsInfo(ticketsInfoVOList, ticketsInfoDynList, ticketTypeId, realQty);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
            ticketsInfoVOLists.addAll(ticketsInfoVOList);
        }
        return ticketsInfoVOLists;
    }

    @Override
    protected void setValidityDays(TicketsInfoVO vo, DynamicObject ticketSourceDyn, DynamicObject ticketsTypeDyn) {
        int validityDays = ticketsTypeDyn.getInt("validitydays");
        Date now = new Date();
        Date startDate = CalendarUtil.getDayStartTime((Date)now);
        Date endDate = CalendarUtil.getDayEndTime((Date)now);
        endDate = CalendarUtil.calculateDayAdd((Date)endDate, (int)(validityDays - 1));
        vo.setValiditydDays(Integer.valueOf(validityDays));
        vo.setStartTime(startDate);
        vo.setEndtime(endDate);
    }

    public List<TicketsInfoVO> convertDyn2VO(DynamicObject ticketInfoGiftEntryDyn, DynamicObject retailBillDyn) {
        Date currDate = TimeServiceHelper.now();
        long ticketTypeID = this.getBaseDataLongPkId(ticketInfoGiftEntryDyn, "tickettype");
        DynamicObject ticketsTypeDyn = this.getBaseDataByPkId(ticketTypeID, "gcm_ticketstype");
        int qty = ticketInfoGiftEntryDyn.getInt("qty");
        if (ticketTypeID <= 0L || qty <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d60\u9001\u793c\u5238\u7c7b\u578b\u548c\u6570\u91cf", (String)"TicketInfoGiftProcessor_2", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        ArrayList<TicketsInfoVO> TicketsInfoVOList = new ArrayList<TicketsInfoVO>(qty);
        for (int i = 0; i < qty; ++i) {
            TicketsInfoVO vo = new TicketsInfoVO();
            vo.setTicketTypeID(ticketTypeID);
            vo.setTicketStatus(TicketStatusEnum.SEND.getName());
            vo.setSouceType(TicketSourceTypeEnum.MAKE.getName());
            vo.setGifterID(this.getBaseDataLongPkId(retailBillDyn, "saler"));
            vo.setGiftTime(currDate);
            vo.setGiftOrgID(this.getBaseDataLongPkId(retailBillDyn, "bizorgid"));
            vo.setGiftBranchID(this.getBaseDataLongPkId(retailBillDyn, "salebranchid"));
            vo.setGiftBillNO(retailBillDyn.getString("billno"));
            vo.setGiftBillID(((Long)retailBillDyn.getPkValue()).longValue());
            vo.setVipID(this.getBaseDataLongPkId(ticketInfoGiftEntryDyn, "emember"));
            vo.setBizOrgID(this.getBaseDataLongPkId(retailBillDyn, "bizorgid"));
            this.setPropertyByTicketType(vo, ticketsTypeDyn);
            this.setValidityDays(vo, ticketInfoGiftEntryDyn, ticketsTypeDyn);
            TicketsInfoVOList.add(vo);
        }
        return TicketsInfoVOList;
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
        List billIds = ticketInfoParamVo.getBillIds();
        if (CollectionUtils.isEmpty((Collection)billIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570\uff1abillids", (String)"TicketInfoGiftProcessor_7", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    protected void setBizInfo(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
        ticketsInfoDyn.set("gifterid", (Object)vo.getGifterID());
        ticketsInfoDyn.set("gifttime", (Object)vo.getGiftTime());
        ticketsInfoDyn.set("giftorgid", (Object)vo.getGiftOrgID());
        ticketsInfoDyn.set("giftbranchid", (Object)vo.getGiftBranchID());
        ticketsInfoDyn.set("giftbillno", (Object)vo.getGiftBillNO());
        ticketsInfoDyn.set("giftbillid", (Object)vo.getGiftBillID());
        ticketsInfoDyn.set("vipid", (Object)vo.getVipID());
    }
}

