/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoSaveProcessor;
import kd.drp.dbd.enums.TicketSourceTypeEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;
import kd.drp.dbd.utils.CalendarUtil;

public class TicketInfoMakeProcessor
extends TicketInfoSaveProcessor {
    @Override
    List<TicketsInfoVO> convertDyn2VO(DynamicObject ticketMakeDyn) {
        Date currDate = TimeServiceHelper.now();
        int ticketMakeQty = 0;
        if (null == ticketMakeDyn) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5236\u4f5c\u793c\u5238\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570", (String)"TicketInfoMakeProcessor_0", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        ticketMakeQty = ticketMakeDyn.getInt("ticketmakeqty");
        if (ticketMakeQty <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5236\u5238\u6570\u91cf", (String)"TicketInfoMakeProcessor_1", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        long ticketTypeID = this.getBaseDataLongPkId(ticketMakeDyn, "ticketstypeid");
        DynamicObject ticketsTypeDyn = this.getBaseDataByPkId(ticketTypeID, "gcm_ticketstype");
        ArrayList<TicketsInfoVO> TicketsInfoVOList = new ArrayList<TicketsInfoVO>(ticketMakeQty);
        for (int i = 0; i < ticketMakeQty; ++i) {
            TicketsInfoVO vo = new TicketsInfoVO();
            vo.setTicketTypeID(ticketTypeID);
            vo.setTicketQty(Integer.valueOf(ticketMakeQty));
            vo.setTicketStatus(TicketStatusEnum.NO_MAKE.getName());
            vo.setSouceType(TicketSourceTypeEnum.MAKE.getName());
            vo.setReceiveBranchID(this.getBaseDataLongPkId(ticketMakeDyn, "receivebranchid"));
            vo.setComment(ticketMakeDyn.getString("comment"));
            this.setValidityDays(vo, ticketMakeDyn, ticketsTypeDyn);
            vo.setMakerID(Long.parseLong(RequestContext.get().getUserId()));
            vo.setMakeTime(currDate);
            vo.setMakeOrgID(this.getBaseDataLongPkId(ticketMakeDyn, "org"));
            vo.setMakeBranchID(this.getBaseDataLongPkId(ticketMakeDyn, "makebranchid"));
            vo.setMakeBillNO(ticketMakeDyn.getString("billno"));
            vo.setMakeBillID(((Long)ticketMakeDyn.getPkValue()).longValue());
            vo.setBizOrgID(this.getBaseDataLongPkId(ticketMakeDyn, "org"));
            this.setPropertyByTicketType(vo, ticketsTypeDyn);
            TicketsInfoVOList.add(vo);
        }
        return TicketsInfoVOList;
    }

    @Override
    protected void setValidityDays(TicketsInfoVO vo, DynamicObject ticketMakeDyn, DynamicObject ticketsTypeDyn) {
        Date startDate = ticketMakeDyn.getDate("startdate");
        Date endDate = ticketMakeDyn.getDate("enddate");
        int dayInterval = CalendarUtil.calculateDayInterval((Date)startDate, (Date)endDate);
        vo.setStartTime(startDate);
        vo.setEndtime(endDate);
        vo.setValiditydDays(Integer.valueOf(dayInterval));
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    void setBizInfo(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
        ticketsInfoDyn.set("makerid", (Object)vo.getMakerID());
        ticketsInfoDyn.set("maketime", (Object)vo.getMakeTime());
        ticketsInfoDyn.set("makeorgid", (Object)vo.getMakeOrgID());
        ticketsInfoDyn.set("makebranchid", (Object)vo.getMakeBranchID());
        ticketsInfoDyn.set("makebillno", (Object)vo.getMakeBillNO());
        ticketsInfoDyn.set("makebillid", (Object)vo.getMakeBillID());
    }
}

