/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoConsumeProcessor;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;

public class TicketInfoPayProcessor
extends TicketInfoConsumeProcessor {
    @Override
    void setBizInfo(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
        this.checkHasParam(ticketInfoParamVo);
        this.checkInvalidParam(ticketInfoParamVo);
    }

    private void checkInvalidParam(TicketInfoParamVO ticketInfoParamVo) {
        List numbers = ticketInfoParamVo.getNumbers();
        QFilter qFilter = new QFilter("number", "in", (Object)numbers);
        DynamicObject[] ticketInfoDynColl = super.load("gcm_ticketsinfo", "id", qFilter.toArray());
        if (ticketInfoDynColl.length != numbers.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e2d\u6709\u65e0\u6548\u7684\u793c\u5238\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u793c\u5238", (String)"TicketInfoPayProcessor_0", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
    }

    private void checkHasParam(TicketInfoParamVO ticketInfoParamVo) {
        Long consumeOperatorId = ticketInfoParamVo.getConsumeOperatorId();
        Date consumeTime = ticketInfoParamVo.getConsumeTime();
        Long consumeOrgId = ticketInfoParamVo.getConsumeOrgId();
        Long consumeBranchId = ticketInfoParamVo.getConsumeBranchId();
        String consumeBillNo = ticketInfoParamVo.getConsumeBillNo();
        Long consumeBillId = ticketInfoParamVo.getConsumeBillId();
        List numbers = ticketInfoParamVo.getNumbers();
        if (ObjectUtils.isEmpty((Object)consumeOperatorId) || consumeOperatorId <= 0L || ObjectUtils.isEmpty((Object)consumeTime) || consumeTime.compareTo(TimeServiceHelper.now()) > 0 || ObjectUtils.isEmpty((Object)consumeOrgId) || consumeOrgId <= 0L || ObjectUtils.isEmpty((Object)consumeBranchId) || consumeBranchId <= 0L || StringUtils.isEmpty((CharSequence)consumeBillNo) || ObjectUtils.isEmpty((Object)consumeBillId) || consumeBillId <= 0L || CollectionUtils.isEmpty((Collection)numbers)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u9500\u793c\u5238\u5fc5\u8981\u7684\u53c2\u6570", (String)"TicketInfoPayProcessor_2", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected DynamicObject[] updateSetTicketInfo(TicketInfoParamVO ticketInfoParamVo) {
        List numbers = ticketInfoParamVo.getNumbers();
        QFilter qFilter = new QFilter("number", "in", (Object)numbers);
        DynamicObject[] ticketInfoDynColl = super.load("gcm_ticketsinfo", "id,ticketstatus,consumeoperatorid,consumetime,consumeorgid,consumebranchid,consumebillno,consumebillid", qFilter.toArray());
        this.checkTicketInfoStatus(ticketInfoDynColl);
        Long consumeOperatorId = ticketInfoParamVo.getConsumeOperatorId();
        Date consumeTime = ticketInfoParamVo.getConsumeTime();
        Long consumeOrgId = ticketInfoParamVo.getConsumeOrgId();
        Long consumeBranchId = ticketInfoParamVo.getConsumeBranchId();
        String consumeBillNo = ticketInfoParamVo.getConsumeBillNo();
        Long consumeBillId = ticketInfoParamVo.getConsumeBillId();
        for (DynamicObject ticketInfoDyn : ticketInfoDynColl) {
            ticketInfoDyn.set("ticketstatus", (Object)TicketStatusEnum.CHECKED.getName());
            ticketInfoDyn.set("consumeoperatorid", (Object)consumeOperatorId);
            ticketInfoDyn.set("consumetime", (Object)consumeTime);
            ticketInfoDyn.set("consumeorgid", (Object)consumeOrgId);
            ticketInfoDyn.set("consumebranchid", (Object)consumeBranchId);
            ticketInfoDyn.set("consumebillno", (Object)consumeBillNo);
            ticketInfoDyn.set("consumebillid", (Object)consumeBillId);
        }
        return ticketInfoDynColl;
    }

    @Override
    protected void checkTicketInfoStatus(DynamicObject[] ticketInfoDynColl) {
        for (DynamicObject ticketInfoDyn : ticketInfoDynColl) {
            if (!StringUtils.equals((CharSequence)ticketInfoDyn.getString("ticketstatus"), (CharSequence)TicketStatusEnum.CHECKED.getName())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u793c\u5238\u5df2\u88ab\u6838\u9500", (String)"TicketInfoPayProcessor_1", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }
}

