/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoUpdateProcessor;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;

public class TicketInfoPublishProcessor
extends TicketInfoUpdateProcessor {
    @Override
    List<TicketsInfoVO> convertDyn2VO(DynamicObject[] ticketsPublishDynColl) {
        ArrayList<TicketsInfoVO> ticketInfoVOList = new ArrayList<TicketsInfoVO>();
        for (DynamicObject ticketPublishDyn : ticketsPublishDynColl) {
            DynamicObjectCollection ticketsInfoEntryColl = ticketPublishDyn.getDynamicObjectCollection("entryentity");
            if (ticketsInfoEntryColl.size() <= 0) continue;
            for (DynamicObject ticketInfoEntryDyn : ticketsInfoEntryColl) {
                TicketsInfoVO vo = new TicketsInfoVO();
                vo.setId(this.getBaseDataLongPkId(ticketInfoEntryDyn, "ticketid"));
                vo.setTicketStatus(TicketStatusEnum.SEND.getName());
                vo.setPublisherID(Long.parseLong(RequestContext.get().getUserId()));
                vo.setPublishTime(TimeServiceHelper.now());
                vo.setPublishBranchID(this.getBaseDataLongPkId(ticketPublishDyn, "branchid"));
                vo.setPublishOrgID(this.getBaseDataLongPkId(ticketPublishDyn, "org"));
                vo.setPublishBillNO(ticketPublishDyn.getString("billno"));
                vo.setPublishBillID(((Long)ticketPublishDyn.getPkValue()).longValue());
                vo.setRealSaleAmount(ticketInfoEntryDyn.getBigDecimal("realsaleamount"));
                long vipid = this.getBaseDataLongPkId(ticketInfoEntryDyn, "vipid");
                vo.setVipID(vipid);
                ticketInfoVOList.add(vo);
            }
        }
        return ticketInfoVOList;
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    void setBizInfo(DynamicObject dyn, TicketsInfoVO vo) {
        if (vo.getPublisherID() > 0L) {
            dyn.set("publisherid", (Object)vo.getPublisherID());
            dyn.set("publishtime", (Object)vo.getPublishTime());
            dyn.set("publishbranchid", (Object)vo.getPublishBranchID());
            dyn.set("publishorgid", (Object)vo.getPublishOrgID());
            dyn.set("publishbillno", (Object)vo.getPublishBillNO());
            dyn.set("publishbillid", (Object)vo.getPublishBillID());
            dyn.set("vipid", (Object)vo.getVipID());
            dyn.set("realsaleamount", (Object)vo.getRealSaleAmount());
        }
    }
}

