/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoQueryProcessor;
import kd.drp.dbd.pojo.TicketInfoParamVO;

public class TicketInfoQueryListProcessor
extends TicketInfoQueryProcessor {
    @Override
    QFilter[] buildQFilters(TicketInfoParamVO ticketInfoParamVo) {
        QFilter filter = super.buildBaseQFilter(ticketInfoParamVo);
        Long memberId = ticketInfoParamVo.getMemberId();
        String name = ticketInfoParamVo.getName();
        Date currentDate = TimeServiceHelper.now();
        String number = ticketInfoParamVo.getNumber();
        String ticketStatus = ticketInfoParamVo.getTicketStatus();
        filter.and(new QFilter("vipid", "=", (Object)memberId));
        if (!StringUtils.isEmpty((CharSequence)name)) {
            filter.and(new QFilter("name", "like", (Object)name));
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            filter.and(new QFilter("number", "like", (Object)number));
        }
        if (!StringUtils.isEmpty((CharSequence)ticketStatus)) {
            filter.and(new QFilter("ticketstatus", "=", (Object)ticketStatus));
        }
        return filter.toArray();
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
        Long memberId = ticketInfoParamVo.getMemberId();
        if (memberId == null || memberId < 0L) {
            throw new KDBizException("\u8bf7\u8f93\u5165\u4f1a\u5458id");
        }
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }
}

