/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoProcessor;
import kd.drp.dbd.common.enums.EnableStatusEnum;
import kd.drp.dbd.enums.CancelStatusEnum;
import kd.drp.dbd.enums.DataStatusEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.BranchVO;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;

public abstract class TicketInfoQueryProcessor
extends TicketInfoProcessor {
    @Override
    void setBizInfo(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
    }

    @Override
    public List<TicketsInfoVO> doProcess(TicketInfoParamVO ticketInfoParamVo) {
        QFilter[] filters = this.buildQFilters(ticketInfoParamVo);
        DynamicObject[] ticketInfoDynColl = this.doQuery(filters);
        if (ticketInfoDynColl.length == 0) {
            return new ArrayList<TicketsInfoVO>(0);
        }
        List<TicketsInfoVO> ticketsInfoVOS = this.convertDyn2VO(ticketInfoDynColl);
        return ticketsInfoVOS;
    }

    private DynamicObject[] doQuery(QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)"gcm_ticketsinfo", (String)"id,name,number,minconsumeamount,starttime,endtime,condition,ticketapplyterminal,ticketvalue,ticketcurrencyid,ticketstatus,tickettypeid,ticketsdistributeid,isneedencryptverify,tencent,marketactivityid", (QFilter[])filters);
    }

    abstract QFilter[] buildQFilters(TicketInfoParamVO var1);

    List<TicketsInfoVO> convertDyn2VO(DynamicObject[] ticketInfoDynColl) {
        ArrayList<TicketsInfoVO> ticketsInfoVoList = new ArrayList<TicketsInfoVO>(ticketInfoDynColl.length);
        for (DynamicObject dyn : ticketInfoDynColl) {
            TicketsInfoVO vo = new TicketsInfoVO();
            vo.setName(dyn.getString("name"));
            vo.setNumber(dyn.getString("number"));
            vo.setMinConsumeAmount(dyn.getBigDecimal("minconsumeamount"));
            vo.setStartTime(dyn.getDate("starttime"));
            vo.setEndtime(dyn.getDate("endtime"));
            vo.setCondition(dyn.getString("condition"));
            vo.setTicketApplyTerminal(dyn.getString("ticketapplyterminal"));
            vo.setTicketValue(dyn.getBigDecimal("ticketvalue"));
            vo.setTicketCurrencyID(this.getBaseDataLongPkId(dyn, "ticketcurrencyid"));
            vo.setTicketStatus(dyn.getString("ticketstatus"));
            vo.setNeedEncryptVerify(Boolean.valueOf(dyn.getBoolean("isneedencryptverify")));
            vo.setTencent(dyn.getString("tencent"));
            vo.setMarketActivityID(this.getBaseDataLongPkId(dyn, "marketactivityid"));
            this.setTicketBranch(vo, dyn);
            ticketsInfoVoList.add(vo);
        }
        return ticketsInfoVoList;
    }

    private QFilter buildBaseQFilters(JSONObject jsonParam) {
        Date billDate = jsonParam.getDate("billdate");
        Long branchId = jsonParam.getLong("branchid");
        Long aLong = jsonParam.getLong("customerid");
        QFilter filter = new QFilter("starttime", ">=", (Object)billDate);
        filter.and(new QFilter("endtime", "<=", (Object)billDate));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("ticketstatus", "=", (Object)TicketStatusEnum.SEND.getName()));
        filter.and(new QFilter("cancelstatus", "=", (Object)CancelStatusEnum.NOCANCEL));
        filter.and(new QFilter("vipid", "is null", (Object)""));
        filter.or(new QFilter("vipid", "=", (Object)""));
        return filter;
    }

    protected void setTicketBranch(TicketsInfoVO ticketInfoVo, DynamicObject ticketInfoDyn) {
        String controlMethod;
        long ticketTypeId = this.getBaseDataLongPkId(ticketInfoDyn, "tickettypeid");
        DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"gcm_ticketstype", (String)"controlmethod,treeentryentity,treeentryentity.branch");
        ArrayList<BranchVO> branchVos = new ArrayList<BranchVO>();
        switch (controlMethod = ticketTypeDyn.getString("controlmethod")) {
            case "0": {
                break;
            }
            case "1": {
                long ticketDistributeId = this.getBaseDataLongPkId(ticketInfoDyn, "ticketsdistributeid");
                if (ticketDistributeId <= 0L) break;
                DynamicObject ticketDistributeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketDistributeId, (String)"gcm_issuescheme", (String)"id,branchid");
                DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)this.getBaseDataLongPkId(ticketDistributeDyn, "branchid"), (String)"mdr_customer", (String)"id,number,name");
                BranchVO branchVo = new BranchVO(Long.valueOf(branchDyn.getLong("id")), branchDyn.getString("name"), branchDyn.getString("number"));
                branchVos.add(branchVo);
                break;
            }
            case "2": {
                DynamicObjectCollection branchRangeDynColl = ticketTypeDyn.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject branchRangeDyn : branchRangeDynColl) {
                    DynamicObject branchDyn = branchRangeDyn.getDynamicObject("branch");
                    BranchVO branchVo = new BranchVO(Long.valueOf(branchDyn.getLong("id")), branchDyn.getString("name"), branchDyn.getString("number"));
                    branchVos.add(branchVo);
                }
                break;
            }
        }
        ticketInfoVo.setList(branchVos);
    }

    protected QFilter buildBaseQFilter(TicketInfoParamVO ticketInfoParamVo) {
        QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.toString());
        filter.and(new QFilter("status", "=", (Object)DataStatusEnum.AUDITED.toString()));
        filter.and(new QFilter("cancelstatus", "=", (Object)CancelStatusEnum.NOCANCEL.toString()));
        return filter;
    }
}

