/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoUpdateProcessor;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;

public class TicketInfoRecycleProcessor
extends TicketInfoUpdateProcessor {
    @Override
    List<TicketsInfoVO> convertDyn2VO(DynamicObject[] ticketRecycleDynColl) {
        ArrayList<TicketsInfoVO> ticketInfoVOList = new ArrayList<TicketsInfoVO>();
        for (DynamicObject ticketRecycle : ticketRecycleDynColl) {
            DynamicObjectCollection ticketsInfoEntryColl = ticketRecycle.getDynamicObjectCollection("entryentity");
            if (ticketsInfoEntryColl.size() <= 0) continue;
            for (DynamicObject ticketInfoEntry : ticketsInfoEntryColl) {
                TicketsInfoVO vo = new TicketsInfoVO();
                vo.setId(this.getBaseDataLongPkId(ticketInfoEntry, "ticketid"));
                vo.setTicketStatus(TicketStatusEnum.RECOVERY.getName());
                vo.setRecyclerID(Long.parseLong(RequestContext.get().getUserId()));
                vo.setRecycleTime(TimeServiceHelper.now());
                vo.setRecycleBranchID(this.getBaseDataLongPkId(ticketRecycle, "branchid"));
                vo.setRecycleOrgID(this.getBaseDataLongPkId(ticketRecycle, "org"));
                vo.setRecycleBillNO(ticketRecycle.getString("billno"));
                vo.setRecycleBillID(((Long)ticketRecycle.getPkValue()).longValue());
                ticketInfoVOList.add(vo);
            }
        }
        return ticketInfoVOList;
    }

    @Override
    void setBizInfo(DynamicObject dyn, TicketsInfoVO vo) {
        if (vo.getRecyclerID() > 0L) {
            dyn.set("recyclerid", (Object)vo.getRecyclerID());
            dyn.set("recycletime", (Object)vo.getRecycleTime());
            dyn.set("recyclebranchid", (Object)vo.getRecycleBranchID());
            dyn.set("recycleorgid", (Object)vo.getRecycleOrgID());
            dyn.set("recyclebillno", (Object)vo.getRecycleBillNO());
            dyn.set("recyclebillid", (Object)vo.getRecycleBillID());
        }
    }

    @Override
    public void preProcess(TicketInfoParamVO ticketInfoParamVo) {
    }

    @Override
    public void afterProcess(TicketInfoParamVO ticketInfoParamVo) {
    }
}

