/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.business.processor.ticketinfo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.helper.TicketRuleCodeHelper;
import kd.drp.dbd.business.processor.ticketinfo.TicketInfoProcessor;
import kd.drp.dbd.common.enums.EnableStatusEnum;
import kd.drp.dbd.enums.CancelStatusEnum;
import kd.drp.dbd.enums.DataStatusEnum;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class TicketInfoSaveProcessor
extends TicketInfoProcessor {
    private static Log logger = LogFactory.getLog(TicketInfoProcessor.class);
    protected static final ReentrantLock lock = new ReentrantLock();

    abstract List<TicketsInfoVO> convertDyn2VO(DynamicObject var1);

    @Override
    public List<TicketsInfoVO> doProcess(TicketInfoParamVO ticketInfoParamVo) {
        List billIds = ticketInfoParamVo.getBillIds();
        String billSource = ticketInfoParamVo.getBillSource();
        Long ticketTypeID = ticketInfoParamVo.getTicketTypeId();
        DynamicObject dynamicObject = this.loadDynamicObject((Long)billIds.get(0), billSource);
        List<TicketsInfoVO> ticketsInfoVOList = this.convertDyn2VO(dynamicObject);
        if (CollectionUtils.isEmpty(ticketsInfoVOList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u793c\u5238\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01", (String)"TicketInfoSaveProcessor_0", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        if (ticketTypeID == null || ticketTypeID < 0L) {
            ticketTypeID = ticketsInfoVOList.get(0).getTicketTypeID();
        }
        try {
            lock.lock();
            Map<String, Object> ticketInfoDynMap = this.batchBuildTicketInfo(ticketsInfoVOList, ticketTypeID);
            List ticketsInfoDynList = (List)ticketInfoDynMap.get("data");
            String realQty = (String)ticketInfoDynMap.get("init");
            this.batchSaveTicketsInfo(ticketsInfoVOList, ticketsInfoDynList, ticketTypeID, realQty);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
        return ticketsInfoVOList;
    }

    protected Map<String, Object> batchBuildTicketInfo(List<TicketsInfoVO> ticketsInfoVOList, Long ticketTypeID) {
        this.checkTicketsInfoVOList(ticketsInfoVOList);
        int size = ticketsInfoVOList.size();
        ArrayList<DynamicObject> ticketsInfoDynList = new ArrayList<DynamicObject>(size);
        DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketTypeID, (String)"gcm_ticketstype");
        if (ObjectUtils.isEmpty((Object)ticketTypeDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u793c\u5238\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"TicketInfoSaveProcessor_1", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        Map<String, Object> ticketNumbersMap = this.getTicketNumbers(this.getBaseDataLongPkId(ticketTypeDyn, "ticketcoderule"), size);
        List ticketNumbers = (List)ticketNumbersMap.get("codes");
        for (int i = 0; i < ticketsInfoVOList.size(); ++i) {
            TicketsInfoVO ticketsInfoVO = ticketsInfoVOList.get(i);
            ticketsInfoVO.setNumber((String)ticketNumbers.get(i));
            DynamicObject ticketsInfoDyn = BusinessDataServiceHelper.newDynamicObject((String)"gcm_ticketsinfo");
            ticketsInfoDyn.set("number", ticketNumbers.get(i));
            ticketsInfoDyn.set("name", (Object)ticketTypeDyn.getString("name"));
            this.setModifiableProperty(ticketsInfoDyn, ticketsInfoVO);
            this.setBizInfo(ticketsInfoDyn, ticketsInfoVO);
            this.setBaseInfo(ticketsInfoDyn, ticketsInfoVO);
            this.setOtherInfo(ticketsInfoDyn, ticketsInfoVO);
            ticketsInfoDynList.add(ticketsInfoDyn);
        }
        ticketNumbersMap.put("data", ticketsInfoDynList);
        return ticketNumbersMap;
    }

    public void setPropertyByTicketType(TicketsInfoVO vo, DynamicObject ticketsTypeDyn) {
        vo.setLocalCurrencyID(this.getBaseDataLongPkId(ticketsTypeDyn, "localcurrency"));
        vo.setTicketCurrencyID(this.getBaseDataLongPkId(ticketsTypeDyn, "ticketcurrency"));
        vo.setHikeAmount(ticketsTypeDyn.getBigDecimal("hikeamount"));
        vo.setTicketValue(ticketsTypeDyn.getBigDecimal("ticketvalue"));
        vo.setRefSaleAmount(ticketsTypeDyn.getBigDecimal("saleamount"));
        vo.setNeedEncryptVerify(Boolean.valueOf(ticketsTypeDyn.getBoolean("isneedencryptverify")));
        vo.setMinConsumeAmount(ticketsTypeDyn.getBigDecimal("minconsumeamount"));
        vo.setCondition(ticketsTypeDyn.getString("condition"));
        vo.setTicketApplyTerminal(ticketsTypeDyn.getString("ticketapplyterminal"));
        vo.setTencent(ticketsTypeDyn.getString("tencent"));
    }

    public void batchSaveTicketsInfo(List<TicketsInfoVO> ticketsInfoVOList, List<DynamicObject> ticketsInfoDynList, long ticketTypeID, String realQty) {
        int size = ticketsInfoVOList.size();
        DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketTypeID, (String)"gcm_ticketstype");
        try {
            Object[] ticketInfoDynCollFromDB = SaveServiceHelper.save((DynamicObject[])ticketsInfoDynList.toArray(new DynamicObject[size]));
            this.updateTicketNumbers(this.getBaseDataLongPkId(ticketTypeDyn, "ticketcoderule"), Integer.parseInt(realQty));
            for (int i = 0; i < ticketInfoDynCollFromDB.length; ++i) {
                DynamicObject dynFromDB = (DynamicObject)ticketInfoDynCollFromDB[i];
                ticketsInfoVOList.get(i).setId(((Long)dynFromDB.getPkValue()).longValue());
            }
        }
        catch (Throwable e) {
            logger.error("\u6e20\u9053\u4e91\u4fdd\u5b58\u793c\u5238\u8d44\u6599\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    private Map<String, Object> getTicketNumbers(long ticketCodeRuleID, int qty) {
        Map<String, Object> map = TicketRuleCodeHelper.getCodes(ticketCodeRuleID, qty);
        List ticketNumbers = (List)map.get("codes");
        QFilter qFilter = new QFilter("number", "in", (Object)ticketNumbers);
        DynamicObject[] ticketInfoDynColl = BusinessDataServiceHelper.load((String)"gcm_ticketsinfo", (String)"id,number", (QFilter[])qFilter.toArray());
        if (ticketInfoDynColl.length > 0) {
            StringBuilder builder = new StringBuilder();
            HashSet<String> set = new HashSet<String>(16);
            for (DynamicObject ticketInfoDyn : ticketInfoDynColl) {
                set.add(ticketInfoDyn.getString("number"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                builder.append((String)iterator.next());
                builder.append('\uff0c');
            }
            throw new KDBizException("\u793c\u5238\u7f16\u7801:" + builder.toString().substring(0, builder.toString().length() - 1) + "\u91cd\u590d\uff0c\u8bf7\u91cd\u542f\u53d1\u8d77");
        }
        return map;
    }

    private void updateTicketNumbers(long ticketCodeRuleID, int qty) {
        TicketRuleCodeHelper.updateSequence(ticketCodeRuleID, qty);
    }

    private void setModifiableProperty(DynamicObject ticketsInfoDyn, TicketsInfoVO vo) {
        ticketsInfoDyn.set("localcurrencyid", (Object)vo.getLocalCurrencyID());
        ticketsInfoDyn.set("ticketcurrencyid", (Object)vo.getTicketCurrencyID());
        ticketsInfoDyn.set("hikeamount", (Object)vo.getHikeAmount());
        ticketsInfoDyn.set("validitydays", (Object)vo.getValiditydDays());
        ticketsInfoDyn.set("ticketvalue", (Object)vo.getTicketValue());
        ticketsInfoDyn.set("refsaleamount", (Object)vo.getRefSaleAmount());
        ticketsInfoDyn.set("isneedencryptverify", (Object)vo.getNeedEncryptVerify());
        ticketsInfoDyn.set("minconsumeamount", (Object)vo.getMinConsumeAmount());
        ticketsInfoDyn.set("condition", (Object)vo.getCondition());
        ticketsInfoDyn.set("ticketapplyterminal", (Object)vo.getTicketApplyTerminal());
        ticketsInfoDyn.set("tencent", (Object)vo.getTencent());
    }

    private void setBaseInfo(DynamicObject dyn, TicketsInfoVO vo) {
        dyn.set("tickettypeid", (Object)vo.getTicketTypeID());
        dyn.set("comment", (Object)vo.getComment());
        dyn.set("starttime", (Object)vo.getStartTime());
        dyn.set("endtime", (Object)vo.getEndtime());
        dyn.set("ticketstatus", (Object)vo.getTicketStatus());
        dyn.set("soucetype", (Object)vo.getSouceType());
    }

    private void setOtherInfo(DynamicObject dyn, TicketsInfoVO vo) {
        Date currDate = TimeServiceHelper.now();
        dyn.set("creator", (Object)RequestContext.get().getUserId());
        dyn.set("createtime", (Object)currDate);
        dyn.set("bizorgid", (Object)vo.getBizOrgID());
        dyn.set("status", (Object)DataStatusEnum.AUDITED.toString());
        dyn.set("cancelstatus", (Object)CancelStatusEnum.NOCANCEL.toString());
        dyn.set("enable", (Object)EnableStatusEnum.ENABLE.toString());
        if (vo.getModifierID() > 0L) {
            dyn.set("modifier", (Object)vo.getModifierID());
            dyn.set("modifytime", (Object)vo.getModifyTime());
        }
        dyn.set("auditorid", (Object)RequestContext.get().getUserId());
        dyn.set("auditdate", (Object)currDate);
    }

    private void checkTicketsInfoVOList(List<TicketsInfoVO> ticketsInfoVOList) {
        if (ticketsInfoVOList == null || ticketsInfoVOList.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u793c\u5238\u8d44\u6599\u4fe1\u606f", (String)"TicketInfoSaveProcessor_2", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        for (TicketsInfoVO vo : ticketsInfoVOList) {
            StringBuilder strBuilder = new StringBuilder();
            if (vo.getTicketTypeID() <= 0L) {
                strBuilder.append(ResManager.loadKDString((String)"\u793c\u5238\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"TicketInfoSaveProcessor_3", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)vo.getStartTime())) {
                strBuilder.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TicketInfoSaveProcessor_4", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)vo.getEndtime())) {
                strBuilder.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TicketInfoSaveProcessor_5", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)vo.getTicketStatus())) {
                strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u793c\u5238\u72b6\u6001", (String)"TicketInfoSaveProcessor_6", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getLocalCurrencyID() < 0L) {
                strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u672c\u4f4d\u5e01", (String)"TicketInfoSaveProcessor_7", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getTicketCurrencyID() < 0L) {
                strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5238\u9762\u5e01\u522b", (String)"TicketInfoSaveProcessor_8", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getHikeAmount().compareTo(BigDecimal.ZERO) < 0) {
                strBuilder.append(ResManager.loadKDString((String)"\u52a0\u4ef7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6", (String)"TicketInfoSaveProcessor_9", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getTicketValue().compareTo(BigDecimal.ZERO) < 0) {
                strBuilder.append(ResManager.loadKDString((String)"\u5238\u9762\u503c\u5fc5\u987b\u5927\u4e8e\u96f6", (String)"TicketInfoSaveProcessor_10", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getRefSaleAmount().compareTo(BigDecimal.ZERO) < 0) {
                strBuilder.append(ResManager.loadKDString((String)"\u552e\u5238\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6", (String)"TicketInfoSaveProcessor_11", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)vo.getNeedEncryptVerify())) {
                strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u662f\u5426\u9700\u8981\u6821\u9a8c\u5bc6\u7801", (String)"TicketInfoSaveProcessor_12", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (vo.getMinConsumeAmount().compareTo(BigDecimal.ZERO) < 0) {
                strBuilder.append(ResManager.loadKDString((String)"\u6700\u4f4e\u6d88\u8d39\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6", (String)"TicketInfoSaveProcessor_13", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)vo.getCondition())) {
                strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6", (String)"TicketInfoSaveProcessor_14", (String)"drp-gcm-business", (Object[])new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)vo.getTicketApplyTerminal())) continue;
            strBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u793c\u5238\u9002\u7528\u7ec8\u7aef", (String)"TicketInfoSaveProcessor_15", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
    }

    public DynamicObject loadDynamicObject(Long billID, String billSource) {
        if (billID <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5355\u636e\u552f\u4e00ID", (String)"TicketInfoSaveProcessor_16", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billID, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billSource));
        if ((Long)dynamicObject.getPkValue() <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"TicketInfoSaveProcessor_17", (String)"drp-gcm-business", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    protected abstract void setValidityDays(TicketsInfoVO var1, DynamicObject var2, DynamicObject var3);
}

