/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.bill.saleorder;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class SynSaleOrderFailedRecord
extends MdrFormPlugin {
    public static final String SYN_SALE_ORDER = "synsaleorder";
    public static final String TOOL_BARAP = "toolbarap";
    public static final String TOOL_REFRESH = "refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date datatime = new Date();
        this.initSynOrderInfo(datatime);
        this.setSynOrderBillFilter(datatime);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("createdate".equals(key)) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            Date date = (Date)newValue;
            this.initSynOrderInfo(date);
            this.setSynOrderBillFilter(date);
        }
    }

    private void initSynOrderInfo(Date datatime) {
        DynamicObject[] saleordernumbers = this.saleorderInfos(datatime, null);
        ((Label)this.getControl("saleordernumber")).setText(String.valueOf(saleordernumbers.length));
        QFilter qFilter = new QFilter("sync", "=", (Object)"B");
        DynamicObject[] synsuccessnumbers = this.saleorderInfos(datatime, qFilter);
        ((Label)this.getControl("synsuccessnumber")).setText(String.valueOf(synsuccessnumbers.length));
        LocalDate localDate = datatime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime minLocalDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        LocalDateTime maxLocalDateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        QFilter qFilter1 = new QFilter("createdate", ">=", (Object)minLocalDateTime);
        qFilter1.and("createdate", "<=", (Object)maxLocalDateTime);
        if (saleordernumbers != null) {
            Object[] orderidArr = new Object[saleordernumbers.length];
            int i = 0;
            for (DynamicObject saleordernumber : saleordernumbers) {
                orderidArr[i] = saleordernumber.getPkValue();
                ++i;
            }
            qFilter1.and("saleorder", "in", (Object)orderidArr);
        }
        QFilter[] filters = new QFilter[]{qFilter1};
        DynamicObject[] synrecord = BusinessDataServiceHelper.load((String)"mdr_synsaleorder_record", (String)"id,createdate", (QFilter[])filters);
        int synfailnumber = synrecord.length;
        ((Label)this.getControl("synfailnumber")).setText(String.valueOf(synfailnumber));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "refresh": {
                Object newValue = this.getModel().getValue("createdate");
                Date date = (Date)newValue;
                this.initSynOrderInfo(date);
                this.setSynOrderBillFilter(date);
            }
        }
    }

    private void setSynOrderBillFilter(Date datatime) {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        DynamicObject[] saleorderInfos = this.saleorderInfos(datatime, null);
        if (saleorderInfos != null) {
            Object[] orderidArr = new Object[saleorderInfos.length];
            int i = 0;
            for (DynamicObject saleorderInfo : saleorderInfos) {
                orderidArr[i] = saleorderInfo.getPkValue();
                ++i;
            }
            tbFilters.add(new QFilter("saleorder", "in", (Object)orderidArr));
        }
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(tbFilters);
        BillList bill = (BillList)this.getControl(SYN_SALE_ORDER);
        bill.setQueryFilterParameter(filterParameter);
        bill.refresh();
    }

    private DynamicObject[] saleorderInfos(Date datatime, QFilter qFilter1) {
        Object owner = UserUtil.getDefaultOwnerID();
        if (owner.equals(0L)) {
            return new DynamicObject[0];
        }
        boolean isSaler = UserUtil.isSaler((Object)owner);
        LocalDate localDate = datatime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime minLocalDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        LocalDateTime maxLocalDateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        QFilter qFilter = new QFilter("createtime", ">=", (Object)minLocalDateTime);
        qFilter.and("createtime", "<=", (Object)maxLocalDateTime);
        if (isSaler) {
            qFilter.and("owner", "=", owner);
        }
        if (qFilter1 != null) {
            qFilter.and(qFilter1);
        }
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] saleordernumber = BusinessDataServiceHelper.load((String)"mdr_saleorder", (String)"id,customer,createtime,owner", (QFilter[])filters);
        return saleordernumber;
    }
}

