/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class CustomerAddressEditMobPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String ADDRESS = "address";
    public static final String ADDRESS2 = "address2";
    public static final String DETAILADDRESS = "detailaddress";
    public static final String SAVE = "save";
    public static final String SAVEANDNEW = "saveandnew";
    public static final String TELEPHONE = "telephone";

    public void registerListener(EventObject e) {
        this.addF7Listener(this, new String[]{"owner", "customer"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "saveandnew": {
                this.mergeAddress();
                break;
            }
        }
    }

    private void mergeAddress() {
        Object address = this.getModel().getValue(ADDRESS);
        String addressFullName = CustomerAddressEditMobPlugin.getAdminDivisionName(address);
        Object address2 = this.getModel().getValue(ADDRESS2);
        this.getModel().setValue(DETAILADDRESS, (Object)(addressFullName + address2));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        if (this.getParamValue("iscustomer") != null) {
            this.handleForCustomer(propertyName);
        } else {
            this.handleForOwner(propertyName);
        }
    }

    private void handleForCustomer(String propertyName) {
        switch (propertyName) {
            case "customer": {
                this.customerChange();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void handleForOwner(String propertyName) {
        switch (propertyName) {
            case "owner": {
                this.ownerChange();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void ownerChange() {
        Object ownerId = this.getOwnerF7PKValue();
        Set ids = CustomerUtil.getAuthSubsIds((Object)ownerId);
        if (ids != null && !ids.isEmpty()) {
            Iterator iterator = ids.iterator();
            this.setCustomerF7Value(iterator.next());
        } else {
            this.setCustomerF7Value(null);
        }
    }

    private void customerChange() {
        List ownerids = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        if (ownerids != null && !ownerids.isEmpty()) {
            Iterator iterator = ownerids.iterator();
            this.setOwnerF7Value(iterator.next());
        } else {
            this.setOwnerF7Value(null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initDefaultValues();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.isNewCreate()) {
            this.setDisVisible(new String[]{"owner"});
        } else if (this.getParamValue("iscustomer") != null) {
            this.setDisVisible(new String[]{"owner"});
        } else {
            this.setVisible(new String[]{"owner"});
        }
    }

    protected void initDefaultValues() {
        this.setCustomerF7Value(this.getParamValue("customerid"));
        if (this.getParamValue("iscustomer") == null) {
            this.initOwner();
        }
    }

    private void initOwner() {
        List ownerIds = UserUtil.getOwnerIDs();
        if (ownerIds.size() == 1) {
            this.setOwnerF7Value(ownerIds.get(0));
            this.setUnEnable(new String[]{"owner"});
        } else if (ownerIds.size() > 1) {
            this.setOwnerF7Value(ownerIds.get(0));
        }
    }

    private static String getAdminDivisionName(Object adminId) {
        if (adminId == null) {
            return "";
        }
        DynamicObject adminDivision = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(adminId.toString())).toArray());
        if (adminDivision == null) {
            return "";
        }
        String fullName = adminDivision.getString("fullname");
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        return fullName.replaceAll("_", "");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (this.getParamValue("iscustomer") != null) {
            this.setCustomerFilter(key, e);
        } else {
            this.setOwnerFilter(key, e);
        }
    }

    private void setOwnerFilter(String key, BeforeF7SelectEvent e) {
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
                break;
            }
            case "customer": {
                CheckResult re = this.checkOwnerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                    break;
                }
                this.getView().showErrorNotification(re.getMsg());
                e.setCancel(true);
                return;
            }
        }
    }

    private void setCustomerFilter(String key, BeforeF7SelectEvent e) {
        switch (key) {
            case "owner": {
                CheckResult re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                    break;
                }
                this.getView().showErrorNotification(re.getMsg());
                e.setCancel(true);
                return;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
                break;
            }
        }
    }

    private CheckResult checkOwnerBeforeSelect() {
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"CustomerAddressEditMobPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkCustomerBeforeSelect() {
        Object customerId = this.getCustomerF7PKValue();
        if (customerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"CustomerAddressEditMobPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private QFilter getCustomerFilter() {
        QFilter fs = F7Utils.getEnableFilter();
        Object ownerId = this.getOwnerF7PKValue();
        Set ids = CustomerUtil.getAuthSubsIds((Object)ownerId);
        return fs.and("id", "in", (Object)ids);
    }

    private QFilter getOwnerFilter() {
        QFilter fs = F7Utils.getEnableFilter();
        List ownerids = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        return fs.and("id", "in", (Object)ownerids);
    }
}

