/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class CustomerAddressEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String ADDRESS = "address";
    public static final String ADDRESS2 = "address2";
    public static final String DETAILADDRESS = "detailaddress";
    public static final String SAVE = "save";
    public static final String SAVEANDNEW = "saveandnew";
    public static final String TELEPHONE = "telephone";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"customer"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "saveandnew": {
                this.mergeAddress();
                break;
            }
        }
    }

    private void mergeAddress() {
        Object address = this.getModel().getValue(ADDRESS);
        String addressFullName = CustomerAddressEditPlugin.getAdminDivisionName(address);
        Object address2 = this.getModel().getValue(ADDRESS2);
        this.getModel().setValue(DETAILADDRESS, (Object)(addressFullName + address2));
    }

    private static String getAdminDivisionName(Object adminId) {
        String strAdminId;
        if (adminId != null && adminId.toString().length() > 0 && (strAdminId = adminId.toString()).length() > 0) {
            DynamicObject adminDivision = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(strAdminId)).toArray());
            if (adminDivision == null) {
                return "";
            }
            String fullName = adminDivision.getString("fullname");
            if (StringUtils.isEmpty((String)fullName)) {
                return "";
            }
            return fullName.replaceAll("_", "");
        }
        return "";
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                break;
            }
        }
    }

    private QFilter getCustomerFilter() {
        Set ownerIds = UserUtil.getAuthorizedOwnerIDs();
        HashSet allIds = new HashSet();
        for (Object id : ownerIds) {
            allIds.addAll(CustomerUtil.getAuthSubsIds(id));
        }
        return new QFilter("id", "in", allIds);
    }
}

