/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.KV;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class CustomerAdminAddPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String TO_SAVE = "tosave";
    private static final String[] cols = new String[]{"enable", "creator", "createtime"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"customer", "user"});
        UserEdit userEdit = (UserEdit)this.getControl("user");
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                }
            });
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        switch (key = evt.getOperateKey()) {
            case "tosave": {
                this.toSaveRows();
                break;
            }
        }
    }

    private void toSaveRows() {
        DynamicObject[] customerAdmins = this.getCustomerAdmins();
        if (customerAdmins == null) {
            return;
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"dbd_customer_admin", (DynamicObject[])customerAdmins, (OperateOption)OperateOption.create());
        this.getView().close();
    }

    private DynamicObject[] getCustomerAdmins() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("admins");
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u6709\u4e00\u884c\u6709\u6548\u6570\u636e", (String)"CustomerAdminAddPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return null;
        }
        CheckResult result = this.checkRows(rows);
        if (!result.isSuccess()) {
            this.getView().showTipNotification(result.getMsg());
            return null;
        }
        DynamicObject[] customerAdmins = new DynamicObject[rows.size()];
        for (int i = 0; i < customerAdmins.length; ++i) {
            customerAdmins[i] = BusinessDataServiceHelper.newDynamicObject((String)"dbd_customer_admin");
            customerAdmins[i].set("user", ((DynamicObject)rows.get(i)).get("user"));
            customerAdmins[i].set("customer", ((DynamicObject)rows.get(i)).get("customer"));
            this.addCommonInfo(customerAdmins[i]);
        }
        return customerAdmins;
    }

    private CheckResult checkRows(DynamicObjectCollection rows) {
        HashSet<String> ids = new HashSet<String>(rows.size());
        DynamicObject row = null;
        DynamicObject customer = null;
        DynamicObject user = null;
        String idStr = null;
        for (int i = 0; i < rows.size(); ++i) {
            row = (DynamicObject)rows.get(i);
            customer = row.getDynamicObject("customer");
            if (customer == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u8bb0\u5f55\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomerAdminAddPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1});
            }
            user = row.getDynamicObject("user");
            if (user == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u8bb0\u5f55\uff0c\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomerAdminAddPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1});
            }
            idStr = customer.get("id").toString() + user.get("id").toString();
            if (ids.add(idStr)) continue;
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u8bb0\u5f55\u5df2\u5b58\u5728", (String)"CustomerAdminAddPlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1});
        }
        return CheckResult.returnTrue();
    }

    private void addCommonInfo(DynamicObject info) {
        Map<String, Object> infoMap = this.getCommonInfo4Create();
        for (String col : cols) {
            info.set(col, infoMap.get(col));
        }
    }

    private Map<String, Object> getCommonInfo4Create() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("enable", "1");
        info.put("creator", UserUtil.getUserID());
        info.put("createtime", new Date());
        return info;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "customer": 
            case "user": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                if (rows == null || rows.size() == 0) break;
                List<Object> ids = this.getIds(rows);
                int rowIndex = this.getCurrentRowIndex("admins");
                this.setValue(key, ids.get(0), rowIndex);
                if (ids.size() <= 1) break;
                this.handleOtherRows(rowIndex, ids, key);
                break;
            }
        }
    }

    private List<Object> getIds(ListSelectedRowCollection rows) {
        ArrayList<Object> ids = new ArrayList<Object>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        return ids;
    }

    private void handleOtherRows(int currentRowIndex, List<Object> rowValues, String key) {
        Map<String, Object> exsistValues = this.getCopyRowVals(this.getRowInfo("admins", currentRowIndex));
        int[] indexs = this.getModel().appendEntryRow("admins", currentRowIndex + 1, rowValues.size() - 1);
        int len = rowValues.size() - 1;
        for (int i = 0; i < len; ++i) {
            for (Map.Entry<String, Object> col : exsistValues.entrySet()) {
                this.setValue(col.getKey(), col.getValue(), indexs[i]);
            }
            this.setValue(key, rowValues.get(i + 1), indexs[i]);
        }
    }

    private Map<String, Object> getCopyRowVals(DynamicObject row) {
        String[] cols = new String[]{"customer", "user"};
        HashMap<String, Object> vals = new HashMap<String, Object>(cols.length);
        int len = cols.length;
        for (int i = 0; i < len; ++i) {
            vals.put(cols[i], row.get(cols[i]));
        }
        return vals;
    }

    public void afterCreateNewData(EventObject e) {
        this.initcustomers();
        this.initUsers();
    }

    private void initUsers() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONArray ids = (JSONArray)fsp.getCustomParam("userids");
        if (ids == null) {
            return;
        }
        this.loadRows(ids.toArray(), "user");
    }

    private void initcustomers() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONArray ids = (JSONArray)fsp.getCustomParam("customerids");
        if (ids == null) {
            return;
        }
        this.loadRows(ids.toArray(), "customer");
    }

    private void loadRows(Object[] ids, String col) {
        if (ids == null) {
            return;
        }
        this.getModel().deleteEntryData("admins");
        int size = ids.length;
        int[] newRowIndexs = this.getModel().batchCreateNewEntryRow("admins", size);
        for (int i = 0; i < size; ++i) {
            this.setValue(col, ids[i], newRowIndexs[i]);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        int index = e.getRow();
        switch (key) {
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter(index));
                break;
            }
            case "user": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUserFilter(index));
                break;
            }
        }
    }

    private QFilter getUserFilter(int index) {
        DynamicObject rowInfo = this.getRowInfo("admins", index);
        DynamicObject customer = rowInfo.getDynamicObject("customer");
        if (customer == null) {
            return null;
        }
        Set<Object> existUsers = this.getExistIds("user", index);
        QFilter fs = new QFilter("id", "not in", existUsers);
        return fs;
    }

    private QFilter getCustomerFilter(int index) {
        DynamicObject rowInfo = this.getRowInfo("admins", index);
        DynamicObject user = rowInfo.getDynamicObject("user");
        if (user == null) {
            return null;
        }
        Set<Object> existCustomers = this.getExistIds("customer", index);
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("id", "not in", existCustomers);
        return fs;
    }

    private Set<Object> getExistIds(String f7Key, int index) {
        HashSet<Object> ids = new HashSet<Object>();
        QFilter fs = null;
        switch (f7Key) {
            case "customer": {
                fs = this.getExistIdsQFilterByUserInfo(index);
                break;
            }
            case "user": {
                fs = this.getExistIdsQFilterByCustomerInfo(index);
            }
        }
        if (fs != null) {
            ids.addAll(QueryUtil.querySingleCol((String)"dbd_customer_admin", (String)f7Key, (QFilter[])fs.toArray()));
        }
        ids.addAll(this.getExistIDsInPage(f7Key, index));
        return ids;
    }

    private Set<Object> getExistIDsInPage(String f7Key, int index) {
        HashSet<Object> ids = new HashSet<Object>();
        DynamicObject currentRowInfo = this.getRowInfo("admins", index);
        KV keFilter = this.getRowKVFilter(currentRowInfo, f7Key);
        if (keFilter == null) {
            return ids;
        }
        DynamicObject rowInfo = null;
        int count = this.getModel().getEntryRowCount("admins");
        KV kv = null;
        for (int i = 0; i < count; ++i) {
            KV f7KV;
            if (i == index || !keFilter.equals((Object)(kv = this.getRowKVFilter(rowInfo = this.getRowInfo("admins", i), f7Key))) || (f7KV = this.getRowKV(rowInfo, f7Key)) == null) continue;
            ids.add(f7KV.getVal());
        }
        return ids;
    }

    private KV getRowKV(DynamicObject rowInfo, String f7Key) {
        DynamicObject info = rowInfo.getDynamicObject(f7Key);
        if (info == null) {
            return null;
        }
        return new KV(f7Key, info.get("id"));
    }

    private KV getRowKVFilter(DynamicObject rowInfo, String f7Key) {
        switch (f7Key) {
            case "customer": {
                return this.getRowKV(rowInfo, "user");
            }
            case "user": {
                return this.getRowKV(rowInfo, "customer");
            }
        }
        return null;
    }

    private QFilter getExistIdsQFilterByCustomerInfo(int index) {
        DynamicObject rowInfo = this.getRowInfo("admins", index);
        DynamicObject user = rowInfo.getDynamicObject("customer");
        if (user != null) {
            return new QFilter("customer", "=", user.get("id"));
        }
        return null;
    }

    private QFilter getExistIdsQFilterByUserInfo(int index) {
        DynamicObject rowInfo = this.getRowInfo("admins", index);
        DynamicObject user = rowInfo.getDynamicObject("user");
        if (user != null) {
            return new QFilter("user", "=", user.get("id"));
        }
        return null;
    }
}

